/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlAnyURI;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.util.log.internal.Masker;
import org.sourceid.wstrust.model.TokenMaskerFactory;

public class WsFedTokenMasker
implements Masker {
    private static final String XPATH_TOKEN_TYPE = "declare namespace wst='http://schemas.xmlsoap.org/ws/2005/02/trust' .//wst:TokenType";

    @Override
    public XmlObject mask(XmlObject srcXmlObj, Set<String> maskedAttrNames) {
        XmlObject[] tokenTypes = srcXmlObj.selectPath(XPATH_TOKEN_TYPE);
        String tokenTypeStr = null;
        for (XmlObject tokenType : tokenTypes) {
            XmlAnyURI tokenTypeAnyUri;
            String temp;
            if (!(tokenType instanceof XmlAnyURI) || StringUtils.isBlank((String)(temp = (tokenTypeAnyUri = (XmlAnyURI)tokenType).getStringValue()))) continue;
            tokenTypeStr = temp;
            break;
        }
        if (tokenTypeStr == null) {
            return srcXmlObj;
        }
        Masker masker = TokenMaskerFactory.getTokenMasker(tokenTypeStr);
        if (masker != null) {
            return masker.mask(srcXmlObj, maskedAttrNames);
        }
        return srcXmlObj;
    }
}

