/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public enum Protocol implements Serializable
{
    WSFED("WSFED", "WS-Federation"),
    SAML20("urn:oasis:names:tc:SAML:2.0:protocol", "SAML 2.0"),
    SAML11("urn:oasis:names:tc:SAML:1.1:protocol", "SAML 1.1"),
    SAML10("urn:oasis:names:tc:SAML:1.0:protocol", "SAML 1.0"),
    OIDC("OIDC", "OpenID Connect");

    private String protocolUri;
    private List<String> protoSupportList;
    private String label;

    private Protocol(String uri, String label) {
        this.protocolUri = uri;
        this.protoSupportList = Arrays.asList(uri);
        this.label = label;
    }

    public String getProtocolUri() {
        return this.protocolUri;
    }

    public List<String> getProtoSupportList() {
        return this.protoSupportList;
    }

    public static Protocol fromProtocolUri(String protocolUri) {
        for (Protocol p : Protocol.values()) {
            if (!p.getProtocolUri().equals(protocolUri)) continue;
            return p;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }
}

