/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.token.PFInternalTokenGenerator;
import org.sourceid.token.jwt.CookielessTokenGenerator;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.authn.CookieDeserializer;

public final class AuthnApiCookielessUtils {
    public static final String CONFIG_STORE_FILE = "authn-api-cookieless-configuration";
    private static final String CONFIG_KEY_STATE_HEADER_NAME = "state-header-name";
    private static final String CONFIG_DEFAULT_STATE_HEADER_NAME = "X-Pf-Authn-Api-State";
    private static final String CLAIM_NAME_COOKIES = "cookies";
    private static final String CLAIM_NAME_FLOW_ID = "flowId";
    private static final Log logger = LogFactory.getLog(AuthnApiCookielessUtils.class);
    private static final ConfigStore CONFIG_STORE = ConfigStoreFarm.getConfig("authn-api-cookieless-configuration");
    private static final String KEY_COOKIELESS_API_FLOW = "AAPU.CookielessApiFlow";
    private final PFInternalTokenGenerator<String, Object> generator;
    private static final ObjectMapper MAPPER = ObjectMapperFactory.buildObjectMapper();

    public static AuthnApiCookielessUtils newInstance() {
        return new AuthnApiCookielessUtils(new CookielessTokenGenerator());
    }

    AuthnApiCookielessUtils(PFInternalTokenGenerator<String, Object> generator) {
        this.generator = generator;
    }

    public String generateState(HttpServletRequest request, HttpServletRespProxy response) {
        try {
            String flowId = this.getFlowId(request);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            Map<String, String> cookies = HttpServletRespProxy.getLazyCookies(response).entrySet().stream().map(entry -> {
                try {
                    Map<String, Object> cookieMap = CookieDeserializer.toCookieObjectMap((Cookie)entry.getValue());
                    String cookieString = MAPPER.writeValueAsString(cookieMap);
                    return Map.entry((String)entry.getKey(), cookieString);
                }
                catch (IOException e) {
                    String message = "Failed to serialize the cookie for '" + (String)entry.getKey() + "': " + e.getMessage();
                    logger.error((Object)message);
                    logger.debug((Object)message, (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            attributes.put(CLAIM_NAME_COOKIES, cookies);
            attributes.put(CLAIM_NAME_FLOW_ID, flowId);
            String requestState = this.generator.encrypt(attributes);
            HttpServletRespProxy.clearLazyCookies(response);
            return requestState;
        }
        catch (PFInternalTokenException e) {
            logger.error((Object)("failed to issue the state header value" + e.getMessage()));
            logger.debug((Object)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Cookie> getCookies(HttpServletRequest request) {
        String stateHeaderValue = request.getHeader(AuthnApiCookielessUtils.getHeaderName());
        if (StringUtils.isBlank((CharSequence)stateHeaderValue)) {
            return Collections.emptyMap();
        }
        String flowId = this.getFlowId(request);
        if (flowId == null && !this.isInitialRedirectlessRequest(request)) {
            logger.debug((Object)"flowId is not present in the request");
            return Collections.emptyMap();
        }
        try {
            Map<String, Object> decrypt = this.generator.decrypt(stateHeaderValue);
            if (!(decrypt.get(CLAIM_NAME_COOKIES) instanceof Map)) {
                logger.debug((Object)"state header does not contain cookies");
                return Collections.emptyMap();
            }
            if (!(this.isInitialRedirectlessRequest(request) || flowId != null && flowId.equals(decrypt.get(CLAIM_NAME_FLOW_ID)))) {
                logger.debug((Object)"state header does not contain the expected flowId");
                return Collections.emptyMap();
            }
            Map serialized = (Map)decrypt.get(CLAIM_NAME_COOKIES);
            return serialized.entrySet().stream().map(entry -> {
                try {
                    Cookie value = (Cookie)MAPPER.readValue((String)entry.getValue(), Cookie.class);
                    return Map.entry((String)entry.getKey(), value);
                }
                catch (IOException e) {
                    String message = "Failed to deserialize the cookie for: '" + (String)entry.getKey() + "': " + e.getMessage();
                    logger.error((Object)message);
                    logger.debug((Object)message, (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (PFInternalTokenException e) {
            logger.error((Object)("failed to process the received state header" + e.getMessage()));
            logger.debug((Object)e);
            return Collections.emptyMap();
        }
    }

    public boolean isInitialRedirectlessRequest(HttpServletRequest request) {
        return "/as/authorization.oauth2".equals(request.getServletPath()) || "/as/user_authz.oauth2".equals(request.getServletPath());
    }

    public boolean isCookielessApiFlow(Map<String, Object> stateParams) {
        Object cookielessObj = stateParams.get(KEY_COOKIELESS_API_FLOW);
        return cookielessObj != null && (Boolean)cookielessObj != false;
    }

    public void setCookielessApiFlow(Map<String, Object> stateParams, boolean cookieless) {
        stateParams.put(KEY_COOKIELESS_API_FLOW, cookieless);
    }

    public String getFlowId(HttpServletRequest request) {
        String result = InternalAuthnApiSupport.getDefault().getAuthnAPIOAuthFlowID(request);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = AuthnApiSupport.getDefault().getFlowId(request.getPathInfo());
        }
        return result;
    }

    public boolean isCookielessRequestHeaderPresent(HttpServletRequest request) {
        String headerName = AuthnApiCookielessUtils.getHeaderName();
        String headerValue = request.getHeader(headerName);
        return StringUtils.isNotBlank((CharSequence)headerValue);
    }

    public static String getHeaderName() {
        return CONFIG_STORE.getStringValue(CONFIG_KEY_STATE_HEADER_NAME, CONFIG_DEFAULT_STATE_HEADER_NAME);
    }

    static {
        SimpleModule module = new SimpleModule("AuthnApiCookielessModule");
        module.addDeserializer(Cookie.class, (JsonDeserializer)new CookieDeserializer());
        MAPPER.registerModule((Module)module);
    }
}

