/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class AuthnApiPolicyUtil {
    private static final Log log = LogFactory.getLog(AuthnApiPolicyUtil.class);
    private static final String KEY_LAST_AUTHN_API_APP_ID = "AAPU.LastAuthnApiAppId";
    private static final String KEY_EFFECTIVE_AUTHN_API_APP_ID = "AAPU.EffectiveAuthnApiAppId";
    private static final String KEY_AUTHN_FAILED_MODEL = "AAPU.AuthnFailedModel";
    private static final String KEY_REDIRECTLESS_API_FLOW = "AAPU.RedirectlessApiFlow";
    private static final String ATTR_API_FLOW_STATE = "AAPU.ApiFlowState";
    private static AuthnApiPolicyUtil instance = new AuthnApiPolicyUtil();

    public static AuthnApiPolicyUtil getDefault() {
        return instance;
    }

    public AuthnApiApplication getAuthnApiApplication(ConfigurablePlugin plugin, Map<String, Object> stateParams) {
        if (!MgmtFactory.getAuthnApiManager().isApiEnabled()) {
            return null;
        }
        if (!(plugin instanceof AuthnApiPlugin)) {
            return null;
        }
        if (!((AuthnApiPlugin)plugin).getApiPluginDescriptor().isInteractive()) {
            return null;
        }
        String authnApiAppId = (String)stateParams.get("currentAuthnApiApp");
        if (authnApiAppId == null) {
            return null;
        }
        AuthnApiApplication authnApiApp = MgmtFactory.getAuthnApiManager().getApiApplication(authnApiAppId);
        if (authnApiApp == null) {
            throw new ProcessRuntimeException("Failed to find authn API application with ID " + authnApiAppId);
        }
        return authnApiApp;
    }

    public AuthnApiRedirectResult checkSendAuthnApiRedirect(ConfigurablePlugin plugin, AuthnPluginKey pluginKey, HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, String resumePath) throws IOException {
        if (plugin instanceof AuthnApiPlugin && !((AuthnApiPlugin)plugin).getApiPluginDescriptor().isInteractive()) {
            return AuthnApiRedirectResult.CONTINUE;
        }
        if (this.isRedirectlessApiFlow(stateParams)) {
            if (!(plugin instanceof AuthnApiPlugin)) {
                throw new ProcessRuntimeException("Plugin '" + pluginKey.getId() + "' requires browser interaction, which is not supported with the pi.flow response mode");
            }
            return AuthnApiRedirectResult.CONTINUE;
        }
        AuthnApiApplication apiApplication = this.getAuthnApiApplication(plugin, stateParams);
        if (apiApplication == null) {
            if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending API RESUME response for non-API-enabled plugin " + pluginKey));
                }
                AuthnApiSupport.getDefault().writeResumeResponse(request, response, resumePath);
                return AuthnApiRedirectResult.RESUME_SENT;
            }
            return AuthnApiRedirectResult.CONTINUE;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            AuthnApiApplication lastApiApplication = this.getLastAuthnApiApplication(stateParams);
            if (lastApiApplication != null && !lastApiApplication.getId().equals(apiApplication.getId()) && !this.isRedirectlessApiFlow(stateParams)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending API RESUME response in order to invoke authn API application '" + apiApplication.getName() + "' for API-enabled plugin " + pluginKey));
                }
                AuthnApiSupport.getDefault().writeResumeResponse(request, response, resumePath);
                return AuthnApiRedirectResult.RESUME_SENT;
            }
            this.saveLastAuthnApiApplication(stateParams, apiApplication);
            this.saveEffectiveAuthnApiApplication(stateParams, apiApplication);
            return AuthnApiRedirectResult.CONTINUE;
        }
        this.saveEffectiveAuthnApiApplication(stateParams, apiApplication);
        return AuthnApiRedirectResult.REDIRECT_REQUIRED;
    }

    public void redirectToEffectiveAuthnApiApplication(AuthnPluginKey pluginKey, HttpServletResponse response, Map<String, Object> stateParams, String resumePath) throws IOException {
        AuthnApiApplication apiApplication = this.getEffectiveAuthnApiApplication(stateParams);
        if (apiApplication == null) {
            throw new ProcessRuntimeException("No effective authn API application saved in state parameters");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to authn API application '" + apiApplication.getName() + "' for API-enabled plugin " + pluginKey));
        }
        this.saveLastAuthnApiApplication(stateParams, apiApplication);
        StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
        AuthnApiPolicyUtil.getDefault().redirectAuthnApiApplication(response, stateSupport.getContextId(resumePath), apiApplication);
    }

    public AuthnApiApplication getLastAuthnApiApplication(Map<String, Object> stateParams) {
        String appId = (String)stateParams.get(KEY_LAST_AUTHN_API_APP_ID);
        if (appId == null) {
            return null;
        }
        return MgmtFactory.getAuthnApiManager().getApiApplication(appId);
    }

    public void saveLastAuthnApiApplication(Map<String, Object> stateParams, AuthnApiApplication app) {
        stateParams.put(KEY_LAST_AUTHN_API_APP_ID, app.getId());
    }

    public AuthnApiApplication getEffectiveAuthnApiApplication(Map<String, Object> stateParams) {
        String appId = (String)stateParams.get(KEY_EFFECTIVE_AUTHN_API_APP_ID);
        if (appId == null) {
            return null;
        }
        return MgmtFactory.getAuthnApiManager().getApiApplication(appId);
    }

    public void saveEffectiveAuthnApiApplication(Map<String, Object> stateParams, AuthnApiApplication app) {
        stateParams.put(KEY_EFFECTIVE_AUTHN_API_APP_ID, app.getId());
    }

    public void saveAuthnFailedModel(Map<String, Object> stateParams, AuthenticationFailed authnFailed) {
        stateParams.put(KEY_AUTHN_FAILED_MODEL, authnFailed);
    }

    public AuthenticationFailed getAuthnFailedModel(Map<String, Object> stateParams) {
        return (AuthenticationFailed)stateParams.get(KEY_AUTHN_FAILED_MODEL);
    }

    public void redirectAuthnApiApplication(HttpServletResponse resp, String flowId, AuthnApiApplication app) throws IOException {
        String redirectUrl = app.getUrl();
        boolean hasFragment = redirectUrl.contains("#");
        String fragment = StringUtils.substringAfter((String)redirectUrl, (String)"#");
        String base = StringUtils.substringBefore((String)redirectUrl, (String)"#");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("flowId", flowId);
        Object dest = Util.appendQueryParams(base, params);
        if (hasFragment) {
            dest = (String)dest + "#" + fragment;
        }
        resp.sendRedirect((String)dest);
    }

    public String makePluginTypeId(AuthnPluginKey authnPlugin) {
        String pluginClassName = null;
        switch (authnPlugin.getType()) {
            case IDP_ADAPTER: {
                if (AuthnPluginKey.PF_CORE.equals(authnPlugin)) {
                    pluginClassName = "org.sourceid.websso.servlet.EnforcerServletBase";
                    break;
                }
                IdpAuthnAdapterInstance adapterInstance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(authnPlugin.getId());
                if (adapterInstance == null) break;
                pluginClassName = adapterInstance.getDescriptor().getPluginClassName();
                break;
            }
            case SELECTOR: {
                AuthnSelectorInstance selectorInstance = (AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(authnPlugin.getId());
                if (selectorInstance == null) {
                    throw new ProcessRuntimeException("Failed to find selector instance with ID " + authnPlugin.getId());
                }
                pluginClassName = selectorInstance.getDescriptor().getPluginClassName();
                break;
            }
            default: {
                throw new ProcessRuntimeException("Unexpected plugin type: " + authnPlugin.getType());
            }
        }
        return pluginClassName == null ? null : this.makePluginTypeId(pluginClassName);
    }

    public String makePluginTypeId(String pluginClassName) {
        byte[] encodedhash = HashUtil.hashToBytes((String)pluginClassName, (HashAlgorithm)HashAlgorithm.SHA256);
        byte[] firstHalf = Arrays.copyOfRange(encodedhash, 0, encodedhash.length / 2);
        return Base64URL.encodeToString((byte[])firstHalf);
    }

    public void setApiFlowState(HttpServletRequest request, State state) {
        request.setAttribute(ATTR_API_FLOW_STATE, (Object)state);
    }

    public State getApiFlowState(HttpServletRequest request) {
        return (State)request.getAttribute(ATTR_API_FLOW_STATE);
    }

    public boolean isRedirectlessApiFlow(Map<String, Object> stateParams) {
        Object redirectlessObj = stateParams.get(KEY_REDIRECTLESS_API_FLOW);
        return redirectlessObj != null && (Boolean)redirectlessObj != false;
    }

    public void setRedirectlessApiFlow(Map<String, Object> stateParams, boolean redirectless) {
        stateParams.put(KEY_REDIRECTLESS_API_FLOW, redirectless);
    }

    public static enum AuthnApiRedirectResult {
        RESUME_SENT,
        REDIRECT_REQUIRED,
        CONTINUE;

    }
}

