/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessor;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.authn.AuthnProcessorResult;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.sp.CreateSsoRequest;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class IdpConnAuthnProcessor
implements AuthnProcessor<IdpConnAuthnSourceKey> {
    public static final String PARAM_IN_MSG_CTX = "inMsgCtxTempHolder";
    public static final String PARAM_OUT_MSG_CTX = "outMsgCtxTempHolder";
    public static final String PARAM_FULL_TREE_STATE_PARAMS = "fullTreeStateParams";
    public static final String CHAINED_VSID = "chainedVsid";
    private final CreateSsoRequest ssoReqCreator = MetaDataFactory.getLocalMetaData().getProfileProcessFactory().getSsoRequestCreator();
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();

    @Override
    public AuthnProcessorResult lookupAuthN(HttpServletRequest req, HttpServletResponse resp, IdpConnAuthnSourceKey authnSourceKey, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, boolean logoutRequired) throws AuthnAdapterException, IOException, AuthnProcessorException {
        IdpConnHashableAuthnBean session;
        Object trackedParamsObject;
        AuthnPolicyUtil.getDefault().clearCurrentAuthnPlugin(req, stateParams);
        InMessageContext inMsgCtx = (InMessageContext)stateParams.remove(PARAM_IN_MSG_CTX);
        OutMessageContext outMsgCtx = (OutMessageContext)stateParams.remove(PARAM_OUT_MSG_CTX);
        String userId = (String)stateParams.get("chainedUserId");
        OutMessageContext ssoReqMsgCtx = new OutMessageContext(Role.IDP);
        IdpConnection idp = this.connectionManager.getIdpConnectionBySystemId(authnSourceKey.getId());
        ssoReqMsgCtx.setEntityId(idp.getEntityId());
        String chainedVsid = (String)stateParams.get(CHAINED_VSID);
        String virtualServerId = VirtualIdentityUtil.resolve(chainedVsid, idp, true).getVirtualEntityId(DomainMode.RUNTIME);
        ssoReqMsgCtx.setVirtualServerId(virtualServerId);
        ssoReqMsgCtx.setRequestedUserId(userId);
        if (StringUtils.isNotBlank((String)userId)) {
            AuditLogger.setUserName(LogGuard.encode(userId));
        }
        if (!ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(stateParams)) {
            ssoReqMsgCtx.setAdapterId((String)stateParams.get("SpSessionAuthnAdapterId"));
        }
        if ((trackedParamsObject = stateParams.get("pf.TrackedHttpParams")) != null) {
            Map trackedParams = (Map)trackedParamsObject;
            ssoReqMsgCtx.setSupplementalContext("pf.TrackedHttpParams", trackedParams);
        }
        ProfileProcessorMatrix.getInstance().verifyProcessorEnablement(0, idp.getEnabledProfiles());
        req.setAttribute("FEDHUB_IN_REQ_CONTEXT", (Object)inMsgCtx);
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        if (policyTreeState != null) {
            req.setAttribute("ChainedAttributes", policyTreeState.getChainedAttributes());
        }
        ssoReqMsgCtx = this.ssoReqCreator.completeBasicSsoReqCtx(req, resp, idp, ssoReqMsgCtx, authnPolicy);
        State state = new State();
        state.setInMsgCtx(inMsgCtx);
        state.setOutMsgCtx(outMsgCtx);
        if (stateParams.containsKey(PARAM_FULL_TREE_STATE_PARAMS)) {
            state.setParameters((Map)stateParams.get(PARAM_FULL_TREE_STATE_PARAMS));
        } else {
            state.setParameters(stateParams);
        }
        ssoReqMsgCtx.setSupplementalContext("FederationHubOriginalAuthnReqState", state);
        if (outMsgCtx != null) {
            Object uarhCtx;
            Object agrhCtx;
            Object harCtx = outMsgCtx.getSupplementalContext("HandleAuthorizationRequest.state");
            if (harCtx != null) {
                ssoReqMsgCtx.setSupplementalContext("HandleAuthorizationRequest.state", harCtx);
            }
            if ((agrhCtx = outMsgCtx.getSupplementalContext("AccessGrantRequestHandler.state")) != null) {
                ssoReqMsgCtx.setSupplementalContext("AccessGrantRequestHandler.state", agrhCtx);
            }
            if ((uarhCtx = outMsgCtx.getSupplementalContext("UserAuthorizationRequestHandler.state")) != null) {
                ssoReqMsgCtx.setSupplementalContext("UserAuthorizationRequestHandler.state", uarhCtx);
            }
            if (harCtx != null || agrhCtx != null || uarhCtx != null) {
                ssoReqMsgCtx.setTargetResource(StateSupport.getServletPathWithContextRoot(req));
            }
        }
        if ((session = (IdpConnHashableAuthnBean)IdpSessionRegistrySupport.getRegisteredAuthnSession(req, resp, stateParams, authnSourceKey, userId, virtualServerId, authnPolicy)) != null) {
            IdpAuditLogger.logAuthnSession("Using existing authentication session", IdpAuditLogger.AuthnSessionEvent.EVENT_AUTHN_SESSION_USE_EXISTING, session);
            this.updateStateParamsFromSession(session, idp, stateParams);
            return new AuthnProcessorResult(session, ssoReqMsgCtx);
        }
        AuthnProcessorResult result = this.checkSendApiResumeResponse(req, resp, resumePath);
        if (result != null) {
            return result;
        }
        BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
        try {
            HttpServletRespProxy.clearRunnable(resp);
            bindingSvc.transportRequest(req, resp, ssoReqMsgCtx);
        }
        catch (Exception e) {
            throw new AuthnProcessorException("Unable to proxy SSO request: " + e.getMessage(), e);
        }
        AuditLogger.setPartnerId(idp.getEntityId());
        IdpAuditLogger.logAuthnAttempt("Attempting SSO request. ", AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return new AuthnProcessorResult();
    }

    @Override
    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest request, HttpServletResponse response, IdpConnAuthnSourceKey authnSourceKey, String resumePath) throws AuthnAdapterException, IOException {
        return true;
    }

    protected void updateStateParamsFromSession(IdpConnHashableAuthnBean session, IdpConnection idpConn, Map<String, Object> stateParams) {
        LinkedList<String> authnAuthorities = (LinkedList<String>)stateParams.get("authnAuthorityEntityIds");
        if (authnAuthorities == null) {
            authnAuthorities = new LinkedList<String>();
        }
        if (session.getAuthenticatingAuthorities() != null) {
            authnAuthorities.addAll(session.getAuthenticatingAuthorities());
        }
        authnAuthorities.add(idpConn.getEntityId());
        stateParams.put("authnAuthorityEntityIds", authnAuthorities);
    }

    private AuthnProcessorResult checkSendApiResumeResponse(HttpServletRequest request, HttpServletResponse response, String resumePath) throws IOException {
        if (!MgmtFactory.getAuthnApiManager().isApiEnabled()) {
            return null;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            this.sendApiResumeResponse(request, response, resumePath);
            return new AuthnProcessorResult(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        }
        return null;
    }

    private void sendApiResumeResponse(HttpServletRequest req, HttpServletResponse resp, String resumePath) throws IOException {
        AuthnApiSupport.getDefault().writeResumeResponse(req, resp, resumePath);
    }
}

