/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.localidentity.LocalIdentityAdapter;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.LocalIdentitySourceKey;
import org.sourceid.saml20.state.AuthnSourceUserKeyValue;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.util.UserKeyAttributeUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AbstractAdapterAuthnProcessor;

public class LocalIdentityAuthnProcessor
extends AbstractAdapterAuthnProcessor<LocalIdentitySourceKey> {
    private final IdpAuthenticationAdapter adapter;

    public LocalIdentityAuthnProcessor(IdpAuthenticationAdapterV2 adapter) {
        this.adapter = adapter;
    }

    @Override
    protected IdpAuthenticationAdapter getAuthnAdapter(String adapterInstanceId, String entityId) {
        return this.adapter;
    }

    @Override
    protected Map<String, Object> getAdditionalParams(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams) {
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        Object inboundAttrs = stateParams.get("inboundAttributes");
        additionalParams.put("AccountLinking", stateParams.get("AccountLinking"));
        if (inboundAttrs != null) {
            additionalParams.put("inboundAttributes", inboundAttrs);
        }
        ArrayList sessionAdapters = new ArrayList();
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        if (policyTreeState != null && policyTreeState.getAuthnPolicyAttrsHolder() != null) {
            AuthnSourceSupportBase.AuthnPolicyAttrsHolder holder = policyTreeState.getAuthnPolicyAttrsHolder();
            holder.getAuthnBeans().forEach(bean -> this.populateSessionAdaptersIntoList(sessionAdapters, bean.getAuthnSourceKey()));
        }
        additionalParams.put("pf.local.identity.session.adapters", sessionAdapters);
        additionalParams.put("pf.local.identity.session.info", IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, stateParams));
        if (this.isEmailOwnershipVerificationRequest(stateParams)) {
            additionalParams.put("pf.local.identity.email.verification.request", true);
        } else if (this.isProfileManagementRequest(stateParams)) {
            additionalParams.put("pf.local.identity.profile.management.request", true);
        }
        return additionalParams;
    }

    private void populateSessionAdaptersIntoList(List<AdapterAuthnSourceKey> sessionAdapters, AuthnSourceKey authnSourceKey) {
        if (authnSourceKey instanceof AdapterAuthnSourceKey) {
            AdapterAuthnSourceKey adapterAuthnSourceKey = (AdapterAuthnSourceKey)authnSourceKey;
            sessionAdapters.add(adapterAuthnSourceKey);
        }
    }

    private boolean isEmailOwnershipVerificationRequest(Map<String, Object> stateParams) {
        String target = (String)stateParams.get("TARGET");
        if (StringUtils.isNotBlank((String)target)) {
            try {
                URI uri = new URI(target);
                if (uri.getPath() != null) {
                    return uri.getPath().endsWith(LocalIdentityUtils.getSendEmailVerificationPath()) || uri.getPath().endsWith(LocalIdentityUtils.getVerifyEmailPath());
                }
                return false;
            }
            catch (URISyntaxException e) {
                this.log.warn((Object)String.format("Target URL %s is invalid: ", target), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean isProfileManagementRequest(Map<String, Object> stateParams) {
        String target = (String)stateParams.get("TARGET");
        if (StringUtils.isNotBlank((String)target)) {
            try {
                URI uri = new URI(target);
                if (uri.getPath() != null) {
                    return uri.getPath().endsWith(LocalIdentityUtils.getProfileManagementPath());
                }
            }
            catch (URISyntaxException e) {
                this.log.warn((Object)String.format("Target URL %s is invalid: ", target), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    protected AuthnAdapterResponse tryLookupAuthnNoInteraction(IdpAuthenticationAdapterV2 adapter, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Map<String, Object> stateParams, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException {
        return this.doLookupAuthn(adapter, req, resp, params, stateParams, adapterLogoutRequired, false);
    }

    @Override
    protected AuthnAdapterResponse doLookupAuthn(IdpAuthenticationAdapterV2 adapter, LocalIdentitySourceKey adapterKey, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Map<String, Object> stateParams, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException {
        return this.doLookupAuthn(adapter, req, resp, params, stateParams, adapterLogoutRequired, true);
    }

    protected AuthnAdapterResponse doLookupAuthn(IdpAuthenticationAdapterV2 adapter, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Map<String, Object> stateParams, boolean adapterLogoutRequired, boolean allowInteraction) throws IOException, AuthnAdapterException {
        LocalIdentityAdapter localIdentityAdapter = (LocalIdentityAdapter)adapter;
        AuthnAdapterResponse response = localIdentityAdapter.lookupAuthN(req, resp, params, allowInteraction);
        if (!(allowInteraction || response != null && response.getAuthnStatus() != AuthnAdapterResponse.AUTHN_STATUS.FAILURE)) {
            return response;
        }
        Map attrs = response.getAttributeMap();
        IdpSessionRegistrySupport.checkAndUpdateDeviceSharingType(req, resp, stateParams, IdpSessionRegistrySupport.getDeviceSharingType(attrs));
        if (attrs != null && attrs.containsKey("pf.local.identity.reg.adapter.attrs") && (response.getAuthnStatus().equals((Object)AuthnAdapterResponse.AUTHN_STATUS.SUCCESS) || attrs.containsKey("pf.local.identity.reg.pending.email.verify"))) {
            Map adapterAttrs = (Map)attrs.get("pf.local.identity.reg.adapter.attrs");
            for (Map.Entry entry : adapterAttrs.entrySet()) {
                this.createAdapterSession((AdapterAuthnSourceKey)entry.getKey(), req, resp, stateParams, (Map)entry.getValue(), adapterLogoutRequired);
            }
            attrs.remove("pf.local.identity.reg.adapter.attrs");
            attrs.remove("pf.local.identity.reg.pending.email.verify");
        }
        return response;
    }

    private void createAdapterSession(AdapterAuthnSourceKey adapterSrcKey, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, Map<String, Object> map, boolean adapterLogoutRequired) throws AuthnAdapterException {
        String adapterId = adapterSrcKey.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating a session for '" + adapterId + "'."));
        }
        IdpHashableAuthnBean newBean = null;
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        if (policyTreeState != null && policyTreeState.getAuthnPolicyAttrsHolder() != null) {
            AuthnSourceSupportBase.AuthnPolicyAttrsHolder attrsHolder = policyTreeState.getAuthnPolicyAttrsHolder();
            newBean = this.updateAuthnBean(adapterId, attrsHolder, map, stateParams);
            this.updateAttrsHolderWithNewAttrs(adapterSrcKey, attrsHolder, map);
        }
        if (newBean != null) {
            this.populateStateParamWithUserKeys(req, stateParams, adapterSrcKey, map);
            try {
                IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, stateParams, newBean, null, true, adapterLogoutRequired);
            }
            catch (SessionQuotaException e) {
                this.log.warn((Object)("Unable to create sessions after registration for adapter '" + adapterId + "'. Creating a session for this adapter exceeded the quota limit."));
                throw new AuthnAdapterException("Session quota exceeded.", (Throwable)e);
            }
        } else {
            this.log.error((Object)("Unable to locate an authn bean for '" + adapterId + "'. Cannot create an authn session for this adapter."));
        }
    }

    private void populateStateParamWithUserKeys(HttpServletRequest req, Map<String, Object> stateParams, AdapterAuthnSourceKey adapterSrcKey, Map<String, Object> adapterAttributes) {
        String userKeyValue;
        block3: {
            String adapterId = adapterSrcKey != null ? adapterSrcKey.getId() : "";
            userKeyValue = null;
            try {
                userKeyValue = UserKeyAttributeUtil.getUniqueUserKeyValue(adapterSrcKey, adapterAttributes, req);
            }
            catch (AuthnAdapterException | AuthorizationException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Unable to get unique user key value for adapter '" + adapterId + "' while creating authn session for this adapter."), e);
            }
        }
        if (userKeyValue != null) {
            List<AuthnSourceUserKeyValue> authnSourceUserKeyValueList = UserKeyAttributeUtil.getStateParamUserKeysToAssociateWithSessions(stateParams);
            authnSourceUserKeyValueList.add(new AuthnSourceUserKeyValue(adapterSrcKey, userKeyValue));
            stateParams.put("adapterAuthnSourceIdsForUser", authnSourceUserKeyValueList);
        }
    }

    private void updateAttrsHolderWithNewAttrs(AdapterAuthnSourceKey adapterSrcKey, AuthnSourceSupportBase.AuthnPolicyAttrsHolder attrsHolder, Map<String, Object> map) {
        String adapterId = adapterSrcKey.getId();
        AttributeMap authnSourceMap = attrsHolder.getAuthnSourceAttrMaps().get(adapterSrcKey);
        if (authnSourceMap != null) {
            authnSourceMap.clear();
            IdpAuthnAdapterInstance adapter = MgmtFactory.getIdpAdapterManager().getInstance(adapterSrcKey);
            AttributeMap attributeMap = AttrValueSupport.convert(map, adapter.getMaskedFields(), (boolean)adapter.getMaskOgnlValues());
            authnSourceMap.putAll((Map)attributeMap);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Policy tree attributes have been updated for '" + adapterId + "'."));
            }
        }
    }

    private IdpHashableAuthnBean updateAuthnBean(String prevAdapterId, AuthnSourceSupportBase.AuthnPolicyAttrsHolder attrsHolder, Map<String, Object> attributeMap, Map<String, Object> stateParams) {
        IdpHashableAuthnBean currBean = null;
        IdpHashableAuthnBean newBean = null;
        for (int i = 0; i < attrsHolder.getAuthnBeans().size(); ++i) {
            currBean = attrsHolder.getAuthnBeans().get(i);
            if (!currBean.getAuthnSourceKey().getId().equals(prevAdapterId)) continue;
            newBean = new IdpHashableAuthnBean(currBean, attributeMap);
            newBean.setDeviceSharingType(IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(stateParams));
            break;
        }
        if (currBean != null && newBean != null) {
            AuthnSourceSupportBase.updateAuthnBean(stateParams, currBean, newBean);
        }
        return newBean;
    }

    @Override
    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest request, HttpServletResponse response, LocalIdentitySourceKey authnSourceKey, String resumePath) throws AuthnAdapterException, IOException {
        return this.adapter.logoutAuthN(authnIdentifiers, request, response, resumePath);
    }
}

