/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.bindings;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ArtifactSupport {
    private Log log = LogFactory.getLog(this.getClass());
    private BindingService bindingService = GlobalRegistry.getService(BindingService.class);
    private ArtifactPersistenceService artifactPersistenceSvc = StateMgmtFactory.getArtifactPersistenceService();

    public InMessageContext resolve(HttpServletRequest request, HttpServletResponse response, OutMessageContext artReqMsgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        InMessageContext artRespMsgCtx = this.bindingService.transportRequest(request, response, artReqMsgCtx);
        try {
            XmlBeansUtil.validate(artRespMsgCtx.getXmlObject());
        }
        catch (InvalidXmlException e) {
            this.log.warn((Object)("Artifact response message contains invalid xml: " + artRespMsgCtx + " " + e));
        }
        SignatureStatus artResponseSigStatus = artRespMsgCtx.getSignatureStatus();
        if (artResponseSigStatus == SignatureStatus.NOT_PRESENT || artResponseSigStatus == SignatureStatus.UNVERIFIED) {
            if (artRespMsgCtx.isSignatureRequired()) {
                throw new BindingException("Signature required on artifact response message");
            }
        } else {
            if (artResponseSigStatus == SignatureStatus.INVALID) {
                throw new BindingException("Invalid signature on artifact response message");
            }
            if (artResponseSigStatus != SignatureStatus.VALID) {
                throw new BindingException("Artifact response message: unknown signature status: " + artResponseSigStatus);
            }
        }
        return artRespMsgCtx;
    }

    public XmlObject retrieveArtifact(byte[] messageHandle, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, String daart, Log log) {
        try {
            ArtifactPersistenceService.Message storedMsg = this.artifactPersistenceSvc.retrieveAndRemoveArtifact(messageHandle);
            if (storedMsg != null) {
                XmlObject storedXmlObj = storedMsg.getXml();
                outMsgCtx.setMaskedAttributeNames(storedMsg.getMaskedAttributeNames());
                String issuedToEntityId = storedMsg.getEntityId();
                String requestingEntityId = inMsgCtx.getEntityId();
                if (requestingEntityId.equals(issuedToEntityId)) {
                    ConnectionBase connectionBase = MetadataSupport.getBaseConnectionMetadata(inMsgCtx);
                    if (connectionBase.isAlwaysSignArtifactResponse()) {
                        outMsgCtx.setSignaturePolicy(SignaturePolicy.SIGN);
                    }
                    Calendar issueInstant = GeneralXmlUtil.getIssueInstant(storedXmlObj);
                    Calendar timeoutCheck = (Calendar)issueInstant.clone();
                    int timeout = connectionBase.getArtifactTimeoutSeconds();
                    timeoutCheck.add(13, timeout);
                    Calendar nowCalendar = Calendar.getInstance();
                    if (nowCalendar.before(timeoutCheck)) {
                        return storedXmlObj;
                    }
                    StringBuilder msg = new StringBuilder("Requested artifact has timed out (").append(daart);
                    msg.append(") timeout seconds (").append(timeout).append(") issue instant (");
                    msg.append(issueInstant.getTime());
                    msg.append(") current time (").append(nowCalendar.getTime()).append(")");
                    log.warn((Object)msg);
                } else {
                    StringBuilder msg = new StringBuilder("Artifact (").append(daart).append(") was issued to ");
                    msg.append(issuedToEntityId).append(" but ").append(requestingEntityId).append(" tried to retrieve it.");
                    log.warn((Object)msg);
                }
            } else {
                log.warn((Object)("Unable to retrieve message for artifact (" + daart + ")"));
            }
        }
        catch (GeneralServiceException e) {
            log.error((Object)("Unable to retrieve message for artifact (" + daart + ") "), (Throwable)e);
        }
        return null;
    }
}

