/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.profiles.sp.OidcLogoutProcessor;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.PartnerLogoutManager;
import org.sourceid.saml20.profiles.Saml2LogoutProcessor;
import org.sourceid.saml20.profiles.sp.HandleLogoutResponse;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.State;
import org.sourceid.websso.profiles.LogoutProcessor;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.LogoutResultHandler;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class IdpPartnerLogoutManager
implements PartnerLogoutManager {
    private static final Log log = LogFactory.getLog(IdpPartnerLogoutManager.class);
    private static final String KEY_PARTNER_LOGOUT_STATE = "PartnerLogoutState";
    private BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    private PartnerLogoutState logoutState;
    private final LogoutProcessor logoutProcessor;
    private Map<String, Object> params;

    public static IdpPartnerLogoutManager forSaml(Collection<IdpConnHashableAuthnBean> beans, boolean overallResult, List<String> problems, Map<String, Object> params) {
        return new IdpPartnerLogoutManager(new Saml2LogoutProcessor(), beans, overallResult, problems, params);
    }

    public static IdpPartnerLogoutManager forOidc(Collection<IdpConnHashableAuthnBean> beans, boolean overallResult, List<String> problems, Map<String, Object> params) {
        return new IdpPartnerLogoutManager(new OidcLogoutProcessor(), beans, overallResult, problems, params);
    }

    protected IdpPartnerLogoutManager(LogoutProcessor logoutProcessor, Collection<IdpConnHashableAuthnBean> beans, boolean overallResult, List<String> problems, Map<String, Object> params) {
        this.logoutProcessor = logoutProcessor;
        this.logoutState = new PartnerLogoutState(beans, overallResult, problems);
        this.params = params;
        params.put(KEY_PARTNER_LOGOUT_STATE, this.logoutState);
    }

    public static IdpPartnerLogoutManager forSaml(Map<String, Object> params) {
        return new IdpPartnerLogoutManager(new Saml2LogoutProcessor(), params);
    }

    public static IdpPartnerLogoutManager forOidc(Map<String, Object> params) {
        return new IdpPartnerLogoutManager(new OidcLogoutProcessor(), params);
    }

    protected IdpPartnerLogoutManager(LogoutProcessor logoutProcessor, Map<String, Object> params) {
        this.logoutProcessor = logoutProcessor;
        this.params = params;
        this.logoutState = (PartnerLogoutState)params.get(KEY_PARTNER_LOGOUT_STATE);
    }

    @Override
    public boolean doLogout(boolean requestIsBackchannel, String binding, String initiatorEntityId, Class<? extends ResumeRequestFromResponseHandler> handlerClass, InMessageContext origInMsgCtx, OutMessageContext origOutMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        boolean done = false;
        boolean requestSent = false;
        while (!done && !requestSent) {
            Object problem;
            Collection<IdpConnHashableAuthnBean> beansToLogout;
            if (requestIsBackchannel) {
                beansToLogout = this.logoutProcessor.gatherBeansForLogoutRequest(this.logoutState.getBeans(), initiatorEntityId, idpConn -> idpConn.supportsBackChannelSingleLogout());
            } else {
                beansToLogout = this.logoutProcessor.gatherBeansForLogoutRequest(this.logoutState.getBeans(), initiatorEntityId, idpConn -> idpConn.getPreferredSingleLogoutService() != null && this.bindingSvc.isBackChannelBinding(idpConn.getPreferredSingleLogoutService().getBinding()));
                if (beansToLogout.isEmpty()) {
                    beansToLogout = this.logoutProcessor.gatherBeansForLogoutRequest(this.logoutState.getBeans(), initiatorEntityId, idpConn -> true);
                }
            }
            if (beansToLogout.isEmpty()) {
                done = true;
                Collection<IdpConnHashableAuthnBean> remainingBeans = this.logoutProcessor.gatherBeansForLogoutRequest(this.logoutState.getBeans(), initiatorEntityId, idpConn -> true);
                if (remainingBeans.isEmpty()) continue;
                problem = "Not all partner sessions could be terminated using back-channel logout";
                this.logoutState.addProblem((String)problem);
                this.logoutState.setOverallResult(false);
                if (!log.isDebugEnabled()) continue;
                log.debug(problem);
                continue;
            }
            this.removeBeans(beansToLogout);
            try {
                OutMessageContext outMsgCtx = this.logoutProcessor.createLogoutRequest(beansToLogout, binding, req);
                if (requestIsBackchannel) {
                    this.setBackchannelBinding(outMsgCtx, beansToLogout);
                }
                State originalState = new State();
                originalState.setInMsgCtx(origInMsgCtx);
                originalState.setOutMsgCtx(origOutMsgCtx);
                originalState.setParameters(this.params);
                ResumeRequestFromResponseSupport.registerResumeFromResponseHandler(outMsgCtx, handlerClass, req, originalState);
                InMessageContext inMsgCtx = this.transportRequest(outMsgCtx, req, resp);
                if (inMsgCtx != null) {
                    this.handleBackchannelResponse(inMsgCtx, outMsgCtx, req, resp);
                    continue;
                }
                requestSent = true;
            }
            catch (Exception e) {
                problem = "Unexpected problem sending logout request: " + e.getMessage();
                this.logoutState.addProblem((String)problem);
                this.logoutState.setOverallResult(false);
                log.error(problem, (Throwable)e);
            }
        }
        return !requestSent;
    }

    @Override
    public void handleLogoutResult(LogoutResult logoutResult) {
        this.logoutState.setOverallResult(this.logoutState.getOverallResult() && logoutResult.isSuccess());
        if (!logoutResult.isSuccess()) {
            this.logoutState.addProblem(logoutResult.getErrorDescription());
        }
    }

    @Override
    public boolean getOverallResult() {
        return this.logoutState.getOverallResult();
    }

    @Override
    public List<String> getProblems() {
        return this.logoutState.getProblems();
    }

    protected void setBackchannelBinding(OutMessageContext outMsgCtx, Collection<IdpConnHashableAuthnBean> beansToLogout) {
        IdpConnHashableAuthnBean firstBean = beansToLogout.iterator().next();
        IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(firstBean.getAuthnSourceKey().getId(), true);
        Endpoint sloServiceEndpoint = idpConn.getPreferredSingleLogoutService(true);
        outMsgCtx.setEndpoint(sloServiceEndpoint.getFullLocation());
        outMsgCtx.setBinding(sloServiceEndpoint.getBinding());
    }

    protected void removeBeans(Collection<IdpConnHashableAuthnBean> beans) {
        for (IdpHashableAuthnBean idpHashableAuthnBean : beans) {
            this.logoutState.getBeans().remove(idpHashableAuthnBean);
        }
        this.logoutProcessor.invalidateBeans(beans);
    }

    protected InMessageContext transportRequest(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, BindingException, RedirectException, RenderPageException, NoSuchProcessException, HttpStatusCodeException {
        return this.bindingSvc.transportRequest(req, resp, outMsgCtx);
    }

    protected void handleBackchannelResponse(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        LogoutResultHandler logoutResultHandler = new LogoutResultHandler(){

            @Override
            public void handleLogoutResult(LogoutResult result) {
                IdpPartnerLogoutManager.this.handleLogoutResult(result);
            }
        };
        HandleLogoutResponse responseHandler = new HandleLogoutResponse();
        responseHandler.setResultHandler(logoutResultHandler);
        responseHandler.process(reqMsgCtx, respMsgCtx, req, resp);
    }

    private static class PartnerLogoutState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Collection<IdpConnHashableAuthnBean> beans = Collections.emptyList();
        private boolean overallResult;
        private List<String> problems = new ArrayList<String>();

        public PartnerLogoutState(Collection<IdpConnHashableAuthnBean> beans, boolean overallResult, List<String> problems) {
            if (beans != null) {
                this.beans = beans;
            }
            this.overallResult = overallResult;
            if (problems != null) {
                this.problems = new ArrayList<String>(problems);
            }
        }

        public Collection<IdpConnHashableAuthnBean> getBeans() {
            return this.beans;
        }

        public boolean getOverallResult() {
            return this.overallResult;
        }

        public void setOverallResult(boolean result) {
            this.overallResult = result;
        }

        public List<String> getProblems() {
            return this.problems;
        }

        public void addProblem(String problem) {
            this.problems.add(problem);
        }
    }
}

