/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ExceptionLoggingSupport;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class RequestHandlerBase
implements RequestHandler {
    protected final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    protected final SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);
    protected final Log log = LogFactory.getLog(this.getClass());

    protected abstract OutMessageContext getInitialOutMsgCtx(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3);

    protected abstract void handleEx(Exception var1, InMessageContext var2, OutMessageContext var3, Map<String, Object> var4, HttpServletRequest var5, HttpServletResponse var6) throws IOException;

    protected abstract void handle(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3, OutMessageContext var4) throws IOException, RequestProcessingException;

    @Override
    public OutMessageContext process(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Request");
        OutMessageContext outMessageContext = null;
        outMessageContext = this.getInitialOutMsgCtx(inMsgCtx, req, resp);
        outMessageContext.setEntityId(inMsgCtx.getEntityId());
        outMessageContext.setRelayState(inMsgCtx.getRelayState());
        try {
            inMsgCtx.checkThrowDeferredException();
            this.doProcess(inMsgCtx, req, resp, outMessageContext);
        }
        catch (Exception e) {
            this.handleException(req, resp, inMsgCtx, outMessageContext, new HashMap<String, Object>(), e);
        }
        return outMessageContext;
    }

    protected void logFailure(Exception e, OutMessageContext outMsgCtx) {
        if (AuditLogger.getEvent() == null) {
            if (this instanceof SloHandler) {
                AuditLogger.setEvent("SLO");
            } else {
                AuditLogger.setEvent("SSO");
            }
        }
        String className = this.getClass().getName();
        AuditLogger.setStatus("failure");
        if (e.getCause() != null) {
            AuditLogger.setDescription(e.getCause().getMessage());
        } else {
            AuditLogger.setDescription(e.getMessage());
        }
        if (className.indexOf(".openid.") > 0) {
            AsAuditLogger.log(e.getMessage());
        } else if (className.indexOf(".sp.") > 0 || className.indexOf(".rp.") > 0) {
            SpAuditLogger.log(e.getMessage());
        } else {
            IdpAuditLogger.log(e.getMessage());
        }
    }

    protected void doProcess(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        this.validateXml(inMsgCtx);
        this.handle(inMsgCtx, req, resp, outMsgCtx);
    }

    private void validateXml(InMessageContext inMsgCtx) throws RequestProcessingException {
        try {
            XmlObject xmlObject = inMsgCtx.getXmlObject();
            if (xmlObject != null) {
                XmlBeansUtil.validate(xmlObject);
            }
        }
        catch (InvalidXmlException e) {
            String msg = "Request XML is invalid.  Errors: " + e.getErrors() + ". ";
            this.log.error((Object)(msg + inMsgCtx), (Throwable)e);
            throw new RequestProcessingException(msg, e);
        }
    }

    protected void logEx(Exception e) {
        ExceptionLoggingSupport.logException(e);
    }

    protected void handleException(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, Exception e) throws IOException {
        this.logFailure(e, outMsgCtx);
        if (e.getCause() == null || !(e.getCause() instanceof QuietException) && !(e.getCause().getCause() instanceof QuietException)) {
            this.logEx(e);
        }
        this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
    }
}

