/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidGeneralResponseException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResponseHandler;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class ResponseHandlerBase
implements ResponseHandler {
    private static final String UNEXPECTED_EXCEPTION_OCCURRED = "Unexpected exception occurred in Response Handling";
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    protected final SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);

    protected abstract void doProcess(InMessageContext var1, OutMessageContext var2, HttpServletRequest var3, HttpServletResponse var4) throws InvalidResponseException, IOException, RenderPageException;

    protected abstract void handleException(InvalidResponseException var1, InMessageContext var2, OutMessageContext var3, HttpServletRequest var4, HttpServletResponse var5) throws IOException, RenderPageException;

    public void mainProcessTemplate(OutMessageContext reqMstCtx, InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, InvalidResponseException, RenderPageException {
        this.validateXml(inMsgCtx);
        this.checkIssuer(reqMstCtx, inMsgCtx);
        this.verifySignature(inMsgCtx, req);
        this.doProcess(inMsgCtx, reqMstCtx, req, resp);
    }

    @Override
    public void process(OutMessageContext reqMstCtx, InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Response");
        try {
            inMsgCtx.checkThrowDeferredException();
            this.mainProcessTemplate(reqMstCtx, inMsgCtx, req, resp);
        }
        catch (InvalidResponseException e) {
            this.logFailure(e);
            StringBuilder sb = new StringBuilder().append("Invalid response: ");
            sb.append(inMsgCtx).append("-------------------------------------").append(Util.LINE_BREAK);
            sb.append(e.getMessage()).append(Util.LINE_BREAK);
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                sb.append("Cause: ").append(e.getCause().getMessage()).append(Util.LINE_BREAK);
            }
            sb.append("-------------------------------------").append(Util.LINE_BREAK);
            this.log.warn((Object)sb);
            this.handleException(e, inMsgCtx, reqMstCtx, req, resp);
        }
        catch (ProcessRuntimeException e) {
            String msg;
            Throwable exForIRE;
            Throwable cause = e.getCause();
            if (cause instanceof ErrorCodeException) {
                exForIRE = cause;
                msg = "";
            } else {
                exForIRE = e;
                msg = this.getUnexpectedErrorMessage(e);
                this.log.error((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
            }
            this.logFailure(e);
            this.handleException(this.newIRE(msg, exForIRE), inMsgCtx, reqMstCtx, req, resp);
        }
        catch (Exception e) {
            this.logFailure(e);
            String msg = this.getUnexpectedErrorMessage(e);
            this.log.error((Object)msg);
            this.log.debug((Object)msg, (Throwable)e);
            this.handleException(this.newIRE(msg, e), inMsgCtx, reqMstCtx, req, resp);
        }
    }

    protected InvalidResponseException newIRE(String message, Throwable cause) {
        return new InvalidResponseException(message, cause);
    }

    protected InvalidResponseException newIRE(String message) {
        return new InvalidGeneralResponseException(message);
    }

    protected void checkIssuer(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) throws InvalidResponseException {
        String respIssuer;
        String requestedIssuer = reqMsgCtx != null ? reqMsgCtx.getEntityId() : "";
        if (!requestedIssuer.equals(respIssuer = respMsgCtx.getEntityId())) {
            StringBuilder sb = new StringBuilder().append("Issuer of response (").append(respIssuer);
            sb.append(") is not who the request was sent to (").append(requestedIssuer).append(").");
            throw this.newIRE(sb.toString());
        }
    }

    protected void validateXml(InMessageContext inMsgCtx) throws InvalidResponseException {
        try {
            XmlBeansUtil.validate(inMsgCtx.getXmlObject());
        }
        catch (InvalidXmlException e) {
            throw this.newIRE("Response XML is invalid", e);
        }
    }

    protected void verifySignature(InMessageContext inMsgCtx, HttpServletRequest req) throws InvalidResponseException {
        SignatureStatus signatureStatus = inMsgCtx.getSignatureStatus();
        if (signatureStatus == SignatureStatus.NOT_PRESENT) {
            if (inMsgCtx.isSignatureRequired()) {
                throw this.newIRE("Signature required");
            }
        } else {
            if (signatureStatus == SignatureStatus.INVALID) {
                throw this.newIRE("Invalid signature");
            }
            if (signatureStatus == SignatureStatus.UNVERIFIED) {
                if (inMsgCtx.isSignatureRequired()) {
                    this.log.error((Object)"Unable to verify the signature. Please make sure that verification certificates are properly configured and not expired.");
                    throw this.newIRE("Unable to verify the signature. Please make sure that verification certificates are valid and properly configured");
                }
            } else if (signatureStatus != SignatureStatus.VALID) {
                throw this.newIRE("Unknown or unexpected signature status: " + signatureStatus);
            }
        }
    }

    protected void logFailure(Exception e) {
        if (AuditLogger.getEvent() == null) {
            if (this instanceof SloHandler) {
                AuditLogger.setEvent("SLO");
            } else {
                AuditLogger.setEvent("SSO");
            }
        }
        String className = this.getClass().getName();
        AuditLogger.setStatus("failure");
        if (e.getCause() != null) {
            AuditLogger.setDescription(e.getCause().getMessage());
        } else {
            AuditLogger.setDescription(e.getMessage());
        }
        if (className.indexOf(".sp.") > 0 || className.indexOf(".rp.") > 0) {
            SpAuditLogger.log(e.getMessage());
        } else {
            IdpAuditLogger.log(e.getMessage());
        }
    }

    protected final String getUnexpectedErrorMessage(Exception e) {
        StringBuilder errorMessage = new StringBuilder(UNEXPECTED_EXCEPTION_OCCURRED);
        if (e == null) {
            return errorMessage.toString();
        }
        String exceptionMessage = e.getMessage();
        if (StringUtils.isBlank((String)exceptionMessage)) {
            if (e.getCause() == null || StringUtils.isBlank((String)e.getCause().getMessage())) {
                return errorMessage.toString();
            }
            exceptionMessage = e.getCause().getMessage();
        }
        errorMessage.append(": ").append(exceptionMessage);
        return errorMessage.toString();
    }
}

