/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.common.util.TrackedParamsUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.RequestHandlerBase;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandler;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class ResumableRequestHandlerBase
extends RequestHandlerBase
implements ResumableRequestHandler,
ResumeRequestFromResponseHandler {
    private BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    protected StateSupport stateSupport = new StateSupport(this.localMetaData);

    protected abstract void exeResume(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3, OutMessageContext var4, Map<String, Object> var5) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException;

    protected abstract boolean isStateAppropriate(State var1);

    protected abstract String getResumePathQualifier(OutMessageContext var1);

    protected void resume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException {
        try {
            this.exeResume(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (GeneralAdapterException e) {
            String message = "Unexpected Runtime Authn Adapter Integration Problem.";
            if (e.isAllowMessagePropagation()) {
                message = e.getMessage();
            }
            throw new RequestProcessingException(message, e);
        }
        catch (GeneralServiceException e) {
            throw new RequestProcessingException("Unexpected Runtime Service Integration Problem.", e);
        }
    }

    protected void doResumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) {
    }

    @Override
    public OutMessageContext resume(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        String stateKey = this.stateSupport.getStateKey(req, resp);
        State state = StateMgmtFactory.retrieveAndRemoveState(stateKey, true, req, resp);
        this.checkState(stateKey, state);
        InMessageContext inMsgCtx = state.getInMsgCtx();
        OutMessageContext outMsgCtx = state.getOutMsgCtx();
        Map<String, Object> parameters = state.getParameters();
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        try {
            this.resume(inMsgCtx, req, resp, outMsgCtx, parameters);
        }
        catch (Exception e) {
            this.handleException(req, resp, inMsgCtx, outMsgCtx, parameters, e);
        }
        return outMsgCtx;
    }

    @Override
    public void resumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) throws IOException {
        this.doResumeFromResponse(responseObject, respMsgCtx, reqMsgCtx, req, resp, originalState);
        try {
            this.resume(originalState.getInMsgCtx(), req, resp, originalState.getOutMsgCtx(), originalState.getParameters());
        }
        catch (Exception e) {
            this.handleException(req, resp, originalState.getInMsgCtx(), originalState.getOutMsgCtx(), originalState.getParameters(), e);
        }
        try {
            this.bindingSvc.transportResponse(req, resp, null, originalState.getOutMsgCtx());
        }
        catch (BindingException | RedirectException | RenderPageException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    private void checkState(String stateKey, State state) throws RenderPageException {
        if (!this.isStateAppropriate(state)) {
            String msg = "Unable to resume processing because an appropriate saved state was not found for key: " + stateKey;
            throw new RenderPageException(msg, "state.not.found.error.page.template.html");
        }
    }

    protected String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo) {
        return this.stateSupport.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo, this.getResumePathQualifier(outMsgCtx));
    }

    public void addTrackedParams(HttpServletRequest req, Map<String, Object> stateParams) {
        TrackedParamsUtil trackedParamsUtil = new TrackedParamsUtil();
        trackedParamsUtil.addTrackedParamsToState(req, stateParams);
    }
}

