/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.ReqAttrSetCheckingStateSupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.ResponseHandlerBase;
import org.sourceid.websso.profiles.ResumableResponseHandler;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.profiles.StatefulHandler;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class ResumableResponseHandlerBase
extends ResponseHandlerBase
implements ResumableResponseHandler,
StatefulHandler,
ResumeRequestFromResponseHandler {
    private final StateSupport stateSupport = new ReqAttrSetCheckingStateSupport();

    protected abstract void doResume(InMessageContext var1, OutMessageContext var2, HttpServletRequest var3, HttpServletResponse var4, Map<String, Object> var5) throws IOException, GeneralAdapterException, GeneralServiceException;

    protected void resume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        try {
            this.doResume(respMsgCtx, reqMsgCtx, req, resp, params);
        }
        catch (GeneralAdapterException | GeneralServiceException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    protected void doResumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) {
    }

    @Override
    public void resume(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        State state = StateMgmtFactory.retrieveAndRemoveState(this.stateSupport.getStateKey(req, resp), true, req, resp);
        InMessageContext respMsgCtx = state.getInMsgCtx();
        OutMessageContext reqMsgCtx = state.getOutMsgCtx();
        Map<String, Object> params = state.getParameters();
        try {
            this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
        }
        catch (Exception e) {
            String msg = this.getUnexpectedErrorMessage(e);
            this.log.error((Object)msg);
            this.log.debug((Object)msg, (Throwable)e);
            this.handleException(this.newIRE(msg, e), respMsgCtx, reqMsgCtx, req, resp);
        }
    }

    @Override
    public void resumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) throws IOException {
        this.doResumeFromResponse(responseObject, respMsgCtx, reqMsgCtx, req, resp, originalState);
        try {
            this.resume(originalState.getInMsgCtx(), originalState.getOutMsgCtx(), req, resp, originalState.getParameters());
        }
        catch (Exception e) {
            String msg = this.getUnexpectedErrorMessage(e);
            this.log.error((Object)msg);
            this.log.debug((Object)msg, (Throwable)e);
            try {
                this.handleException(this.newIRE(msg, e), originalState.getInMsgCtx(), originalState.getOutMsgCtx(), req, resp);
            }
            catch (RenderPageException renderPageEx) {
                throw new ProcessRuntimeException(renderPageEx);
            }
        }
    }

    @Override
    public String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo) {
        return this.stateSupport.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo, this.getResumePathQualifier(outMsgCtx));
    }

    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }
}

