/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.LogGuard;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.Util;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AsAuditLogger
extends AuditLogger {
    private static final Log log = LogFactory.getLog(AsAuditLogger.class);
    public static final String AUTH_CODE_INVALID_OR_EXPIRED = "Authorization Code Invalid or Expired";
    public static final String DEVICE_CODE_INVALID_OR_EXPIRED = "Device Code Invalid or Expired";
    public static final String ATTR_MAPPING_EXCEPTION = "Attribute Mapping Exception";
    public static final String USER_DENIED_AUTHZ = "User Denied Authorization";
    public static final String USER_GRANTED_AUTHZ = "User Granted Authorization";
    public static final String TOKEN_ISSUED = "Token Issued";
    public static final String TOKEN_REVOKED = "Token Revoked";
    public static final String TOKEN_VALIDATED = "Token Validated";
    public static final String ACCESS_GRANT_MGMT_EXCEPTION = "Access Grant Management Exception";
    public static final String LDAP_EXCEPTION = "LDAP Exception";
    public static final String DATABASE_EXCEPTION = "Database Exception";
    public static final String FILE_IO_EXCEPTION = "File I/O Exception";
    public static final String OAUTH = "OAuth";
    public static final String OAUTH20 = "OAuth20";
    public static final String VALIDATE_GRANT_TYPE = "urn:pingidentity.com:oauth2:grant_type:validate_bearer";
    public static final String TOKEN_AUTHORIZE = "TokenAuthorize";
    private static final String TOKEN_ISSUE = "TokenIssue";
    public static final String TOKEN_REVOKE = "TokenRevoke";
    private static final String TOKEN_VALIDATE = "TokenValidate";
    public static final String INVALID_TOKEN_REQ = "Invalid Request";
    public static final String GRANT_NOT_FOUND_OR_EXP = "Grant not found or expired";
    public static final String USER_NOT_GRANT_OWNER = "User not grant owner";
    protected static final String STARS = "******";
    public static final String TOKEN = "token";
    private static final String IN_MSG_VALUE_MAP = "inmsgmap";
    private static final String OUT_MSG_VALUE_MAP = "outmsgmap";
    private static final Map<Enum<AccessTokenRequestException.Error>, String> accessTokenExceptionDescriptions = new HashMap<Enum<AccessTokenRequestException.Error>, String>();
    private static final Map<Enum<AuthorizationRequestException.Error>, String> authorizationRequestExceptionDescriptions = new HashMap<Enum<AuthorizationRequestException.Error>, String>();

    static String getErrorDesc(String enumAsString) {
        return WordUtils.capitalize((String)StringUtils.replace((String)enumAsString, (String)"_", (String)" "));
    }

    public static void log(String msg) {
        AsAuditLogger.setXmlMsg(AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), IN_MSG_VALUE_MAP);
        AsAuditLogger.setXmlMsg(AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), OUT_MSG_VALUE_MAP);
        ThreadContext.remove((String)IN_MSG_VALUE_MAP);
        ThreadContext.remove((String)OUT_MSG_VALUE_MAP);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"AS");
        AsAuditLogger.updateResponseTime();
        AsAuditLogger.log(log, msg);
        AsAuditLogger.checkUpdateTransactionCounters();
    }

    public static void setGrantType(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.GRANT_TYPE.toString(), (String)value);
        }
    }

    public static void setDescription(String description) {
        if (description != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)LogGuard.encode(description));
        }
    }

    public static void setValidatorId(String validatorId) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.VALIDATOR_ID.toString(), (String)validatorId);
    }

    public static void setDescription(AccessTokenRequestException.Error key) {
        String value = accessTokenExceptionDescriptions.containsKey((Object)key) ? accessTokenExceptionDescriptions.get((Object)key) : key.toString();
        ThreadContext.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)LogGuard.encode(value));
    }

    public static void setDescription(AuthorizationRequestException.Error key) {
        String value = authorizationRequestExceptionDescriptions.containsKey((Object)key) ? authorizationRequestExceptionDescriptions.get((Object)key) : key.toString();
        ThreadContext.put((String)AuditLogger.MDC_KEY.DESCRIPTION.toString(), (String)LogGuard.encode(value));
    }

    public static boolean isDescriptionBlank() {
        return StringUtils.isBlank((String)ThreadContext.get((String)AuditLogger.MDC_KEY.DESCRIPTION.toString()));
    }

    public static void setAttributes(AttributeMap attributes) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ATTRIBUTES.toString(), (String)AsAuditLogger.getAttributesAsString(attributes));
    }

    public static void setInMsgCtx(HttpServletRequest req, Client client) {
        AsAuditLogger.setInMsgCtx(req, client, null);
    }

    public static void setInMsgCtx(HttpServletRequest req, Client client, String grantType) {
        String[] values;
        LinkedHashMap<String, String> parts = new LinkedHashMap<String, String>();
        Map parameterMap = req.getParameterMap();
        if (parameterMap.containsKey("redirect_uri")) {
            values = (String[])parameterMap.get("redirect_uri");
            parts.put("redirect_uri", values[0]);
        }
        if (client != null) {
            if (StringUtils.isNotBlank((String)client.getClientId())) {
                parts.put(Parameters.CLIENT_ID, client.getClientId());
            }
            if (client.hasSecret()) {
                parts.put(Parameters.CLIENT_SECRET, STARS);
            }
        } else {
            String authHeader = req.getHeader("Authorization");
            AsAuditLogger.setClientCredentials(authHeader, parts);
        }
        if (StringUtils.isNotBlank((String)grantType)) {
            parts.put("grant_type", grantType);
        }
        if (parameterMap.containsKey("username")) {
            values = (String[])parameterMap.get("username");
            parts.put("username", values[0]);
        }
        if (parameterMap.containsKey("password")) {
            parts.put("password", STARS);
        }
        if (parameterMap.containsKey("code")) {
            parts.put("code", STARS);
        }
        if (parameterMap.containsKey(TOKEN)) {
            parts.put(TOKEN, STARS);
        }
        if (parameterMap.containsKey("refresh_token")) {
            parts.put("refresh_token", STARS);
        }
        if (parameterMap.containsKey("assertion")) {
            values = (String[])parameterMap.get("assertion");
            parts.put("assertion", values[0]);
        }
        if (parameterMap.containsKey(Parameters.SCOPE)) {
            values = (String[])parameterMap.get(Parameters.SCOPE);
            parts.put(Parameters.SCOPE, values[0]);
        }
        if (parameterMap.containsKey("token_type_hint")) {
            values = (String[])parameterMap.get("token_type_hint");
            parts.put("token_type_hint", values[0]);
        }
        if (parameterMap.containsKey("access_token_manager_id")) {
            values = (String[])parameterMap.get("access_token_manager_id");
            parts.put("access_token_manager_id", values[0]);
        }
        if (parameterMap.containsKey("aud")) {
            values = (String[])parameterMap.get("aud");
            parts.put("aud", values[0]);
        }
        AsAuditLogger.putXmlMsgValuesToMDC(IN_MSG_VALUE_MAP, parts);
    }

    public static void setInMsgCtx(Client client, InMessageContext inMsgCtx, ResponseType rspType) {
        AsAuditLogger.setInMsgCtx(client, inMsgCtx);
        LinkedHashMap<String, String> parts = new LinkedHashMap<String, String>();
        String responseType = rspType.getResponseTypeString();
        if (StringUtils.isNotBlank((String)responseType)) {
            parts.put("response_type", responseType);
        }
        AsAuditLogger.putXmlMsgValuesToMDC(IN_MSG_VALUE_MAP, parts);
    }

    public static void setInMsgCtx(Client client, InMessageContext inMsgCtx) {
        String audience;
        String accessTokenMgrId;
        String scope;
        String redirectUri;
        String state;
        LinkedHashMap<String, String> parts = new LinkedHashMap<String, String>();
        String clientId = client.getClientId();
        if (StringUtils.isNotBlank((String)clientId)) {
            parts.put(Parameters.CLIENT_ID, clientId);
        }
        if (StringUtils.isNotBlank((String)(state = inMsgCtx.getRelayState()))) {
            parts.put("state", state);
        }
        if (StringUtils.isNotBlank((String)(redirectUri = inMsgCtx.getParam("redirect_uri")))) {
            parts.put("redirect_uri", redirectUri);
        }
        if (StringUtils.isNotBlank((String)(scope = inMsgCtx.getParam(Parameters.SCOPE)))) {
            parts.put(Parameters.SCOPE, scope);
        }
        if (StringUtils.isNotBlank((String)(accessTokenMgrId = inMsgCtx.getParam("access_token_manager_id")))) {
            parts.put("access_token_manager_id", accessTokenMgrId);
        }
        if (StringUtils.isNotBlank((String)(audience = inMsgCtx.getParam("aud")))) {
            parts.put("aud", audience);
        }
        AsAuditLogger.putXmlMsgValuesToMDC(IN_MSG_VALUE_MAP, parts);
    }

    public static void setOutMsgCtxWithErrors(Map<String, Object> errorMap) {
        StringBuilder sb = new StringBuilder(100);
        Iterator<Map.Entry<String, Object>> i = errorMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> e = i.next();
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)sb.toString());
    }

    public static void setOutMsgCtx(OutMessageContext outMsgCtx) {
        String scope;
        String accessToken;
        String clientId;
        String code;
        String refreshToken;
        String expiresIn;
        String state;
        LinkedHashMap<String, String> parts = new LinkedHashMap<String, String>();
        String redirectUri = outMsgCtx.getEndpoint();
        if (StringUtils.isNotBlank((String)redirectUri)) {
            parts.put("redirect_uri", redirectUri);
        }
        if (StringUtils.isNotBlank((String)(state = outMsgCtx.getParam("state")))) {
            parts.put("state", state);
        } else {
            state = outMsgCtx.getRelayState();
            if (StringUtils.isNotBlank((String)state)) {
                parts.put("state", state);
            }
        }
        String tokenType = outMsgCtx.getParam("token_type");
        if (StringUtils.isNotBlank((String)tokenType)) {
            parts.put("token_type", tokenType);
        }
        if (StringUtils.isNotBlank((String)(expiresIn = outMsgCtx.getParam("expires_in")))) {
            parts.put("expires_in", expiresIn);
        }
        if (StringUtils.isNotBlank((String)(refreshToken = outMsgCtx.getParam("refresh_token")))) {
            parts.put("refresh_token", STARS);
        }
        if (StringUtils.isNotBlank((String)(code = outMsgCtx.getParam("code")))) {
            parts.put("code", STARS);
        }
        if (StringUtils.isNotBlank((String)(clientId = outMsgCtx.getParam(Parameters.CLIENT_ID)))) {
            parts.put(Parameters.CLIENT_ID, clientId);
        }
        if (StringUtils.isNotBlank((String)(accessToken = outMsgCtx.getParam("access_token")))) {
            parts.put("access_token", STARS);
        }
        if (StringUtils.isNotBlank((String)(scope = outMsgCtx.getParam(Parameters.SCOPE)))) {
            parts.put(Parameters.SCOPE, scope);
        }
        AsAuditLogger.putXmlMsgValuesToMDC(OUT_MSG_VALUE_MAP, parts);
    }

    public static void setConnectionId(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)value);
            Client client = MgmtFactory.getClientManager().getCachedClient(value);
            if (client != null) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)client.getName());
            }
        }
    }

    private static void putXmlMsgValuesToMDC(String mdcKey, Map<String, String> parts) {
        String value = ThreadContext.get((String)mdcKey);
        String flattenedMap = AsAuditLogger.flattenMap(parts);
        Object valueToStore = value == null ? flattenedMap : value + "," + flattenedMap;
        ThreadContext.put((String)mdcKey, (String)valueToStore);
    }

    public static void setInMessageType(String value) {
        if (VALIDATE_GRANT_TYPE.equals(value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)TOKEN_VALIDATE);
        } else if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)TOKEN_ISSUE);
        }
    }

    protected static void setClientCredentials(String authHeader, Map<String, String> parts) {
        if (StringUtils.isNotBlank((String)authHeader)) {
            String[] tokens = authHeader.split(" ");
            String scheme = tokens[0];
            if (tokens.length == 2 && StringUtils.equalsIgnoreCase((String)"Basic", (String)scheme)) {
                String clientSecret;
                String clientIdClientSecret = tokens[1];
                String clientId = StringUtils.substringBefore((String)(clientIdClientSecret = B64.decodeToString((String)clientIdClientSecret)), (String)":");
                if (StringUtils.isNotBlank((String)clientId)) {
                    parts.put(Parameters.CLIENT_ID, clientId);
                }
                if (StringUtils.isNotBlank((String)(clientSecret = StringUtils.substringAfter((String)clientIdClientSecret, (String)":")))) {
                    parts.put(Parameters.CLIENT_SECRET, STARS);
                }
            }
        }
    }

    public static String getAttributesAsString(UserKeyAttributes userKeyAttrs) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (userKeyAttrs != null) {
            for (Map.Entry entry : userKeyAttrs.entrySet()) {
                keyValue.add((String)entry.getKey() + "=" + ((AttributeValue)entry.getValue()).sensitiveToString());
            }
        }
        return Util.listToCommaDelimString(keyValue);
    }

    public static String getAttributesAsString(AttributeMap attributeMap) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (attributeMap != null) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                keyValue.add((String)entry.getKey() + "=" + ((AttributeValue)entry.getValue()).sensitiveToString());
            }
        }
        return Util.listToDelimString(keyValue, ",");
    }

    private static void setXmlMsg(String msgKey, String mapKey) {
        String xmlMsg = ThreadContext.get((String)mapKey);
        if (StringUtils.isNotBlank((String)xmlMsg)) {
            ThreadContext.put((String)msgKey, (String)xmlMsg);
        }
    }

    protected static String flattenMap(Object o) {
        Map m;
        if (o instanceof Map && !(m = (Map)o).isEmpty()) {
            LinkedList<String> l = new LinkedList<String>();
            for (Map.Entry e : m.entrySet()) {
                l.add(AsAuditLogger.getNameValuePair((String)e.getKey(), (String)e.getValue()));
            }
            return Util.listToDelimString(l, ",");
        }
        return "";
    }

    protected static String getNameValuePair(String name, String value) {
        return name + "=" + value;
    }

    public static void setAccessTokenTrackingId(String at) {
        if (StringUtils.isNotBlank((String)at)) {
            String atTrackingId = TrackingIdSupport.generateAtTrackingIdForPA(at);
            ThreadContext.put((String)AuditLogger.MDC_KEY.AT_TRACKING_ID.toString(), (String)atTrackingId);
        }
    }

    public static void setAccessGrantGuid(String accessGrantGuid) {
        if (StringUtils.isNotBlank((String)accessGrantGuid)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.ACCESS_GRANT_GUID.toString(), (String)accessGrantGuid);
        }
    }

    static {
        for (AccessTokenRequestException.Error error : AccessTokenRequestException.Error.values()) {
            accessTokenExceptionDescriptions.put(error, AsAuditLogger.getErrorDesc(error.toString()));
        }
        for (Enum enum_ : AuthorizationRequestException.Error.values()) {
            authorizationRequestExceptionDescriptions.put(enum_, AsAuditLogger.getErrorDesc(enum_.toString()));
        }
    }
}

