/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.profiles.PartnerSessionGroup;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.websso.Protocol;

public abstract class BaseSloTemplateRenderer {
    private static final Log log = LogFactory.getLog(BaseSloTemplateRenderer.class);
    protected static final String VAR_REQUEST_URL = "requestUrl";
    protected static final String VAR_WSF_SP_LIST = "spList";
    protected static final String VAR_WSF_IDP_LIST = "wsfIdpList";
    protected static final String VAR_OIDC_ENDPOINT_LIST = "oidcEndpointList";
    protected static final String VAR_OIDC_FC_LOGOUT_ENDPOINT_LIST = "oidcFCLogoutEndpointList";
    protected static final String VAR_SAML2_SP_LIST = "saml2SpList";
    protected static final String VAR_HAS_SAML2_SP = "hasSaml2Sp";
    protected static final String VAR_IDP_HOST = "idpHost";
    protected static final String VAR_IDP_LOGOUT_SUCCESS = "idpLogoutSuccess";
    protected static final String VAR_RESUME_PATH = "resumepath";
    protected static final String VAR_WREPLY = "wreply";
    protected static final String VAR_ERROR_WREPLY = "errorWreply";
    protected static final String KEY_WSF_SPLIST = "wsfedsplist";
    protected static final String KEY_WSF_IDPLIST = "wsfedidplist";
    protected static final String KEY_OIDC_ENDPOINT_LIST = "oidcEndpointList";
    protected static final String KEY_OIDC_FC_LOGOUT_ENDPOINT_LIST = "oidcFCLogoutEndpointList";
    protected static final String KEY_SAML2_SP_LIST = "saml2splist";
    protected static final String KEY_IDP_LOGOUT_SUCCESS = "idpLogoutSuccess";
    protected static final String KEY_TEMPLATE_RENDERED = "templateRendered";
    protected static final String SIGNOUT_TEMPLATE = "sourceid-wsfed-idp-signout-cleanup-template.html";
    protected static final String INVISIBLE_SIGNOUT_TEMPLATE = "sourceid-wsfed-idp-signout-cleanup-invisible-template.html";
    protected ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
    protected MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    protected MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected SLOSupport sloSupport = new SLOSupport(this.localMetaData);

    public boolean checkRenderTemplate() {
        Map<String, String> wsFedIdpSignoutUrlList = this.getWsFedIdpSignoutUrlList();
        Map<String, String> wsFedSpSignoutCleanupUrlList = this.getWsFedSpSignoutCleanupUrlList();
        List<KeyValuePair> oidcLogoutUrlList = this.getOidcLogoutUrlList();
        List<KeyValuePair> oidcFCLogoutUrlList = this.getOidcFCLogoutUrlList();
        return wsFedIdpSignoutUrlList != null && !wsFedIdpSignoutUrlList.isEmpty() || wsFedSpSignoutCleanupUrlList != null && !wsFedSpSignoutCleanupUrlList.isEmpty() || oidcLogoutUrlList != null && !oidcLogoutUrlList.isEmpty() || oidcFCLogoutUrlList != null && !oidcFCLogoutUrlList.isEmpty();
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean isTemplateRendered() {
        Boolean result = (Boolean)this.params.get(KEY_TEMPLATE_RENDERED);
        return result != null && result != false;
    }

    public boolean isIdpLogoutSuccess() {
        Boolean result = (Boolean)this.params.get("idpLogoutSuccess");
        return result != null && result != false;
    }

    public void setIdpLogoutSuccess(boolean success) {
        this.params.put("idpLogoutSuccess", success);
    }

    public abstract void renderTemplate(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    protected void setTemplateRendered(boolean rendered) {
        this.params.put(KEY_TEMPLATE_RENDERED, rendered);
    }

    protected Map<String, String> getWsFedSpSignoutCleanupUrlList() {
        return (Map)this.params.get(KEY_WSF_SPLIST);
    }

    protected Map<String, String> getWsFedIdpSignoutUrlList() {
        return (Map)this.params.get(KEY_WSF_IDPLIST);
    }

    protected List<KeyValuePair> getOidcLogoutUrlList() {
        return (List)this.params.get("oidcEndpointList");
    }

    protected List<KeyValuePair> getOidcFCLogoutUrlList() {
        return (List)this.params.get("oidcFCLogoutEndpointList");
    }

    protected SessionInfo saveAndUnregisterWsFedAndOidcSessions(HttpServletRequest req, HttpServletResponse resp) {
        SessionInfo result = new SessionInfo();
        SLOSupport sloSupport = new SLOSupport(this.localMetaData);
        Map<IdpHashableAuthnBean, Collection<Session>> registered = IdpSessionRegistrySupport.getRegisteredForSession(req, resp);
        result.setIssuedSessions(registered);
        List<WebSsoSession> issuedWsFedSpSessions = sloSupport.getProtocolSessions(registered, Protocol.WSFED);
        Map<String, String> wsFedSpSignoutCleanupUrlList = this.makeWsFedSpSignoutCleanupUrlList(issuedWsFedSpSessions);
        this.params.put(KEY_WSF_SPLIST, wsFedSpSignoutCleanupUrlList);
        result.setIssuedWsFedSpSessions(issuedWsFedSpSessions);
        Map<IdpHashableAuthnBean, List<OidcSession>> issuedOidcSessions = sloSupport.getOidcSessionsByAuthnBean(registered);
        ArrayList<OidcSession> terminatedSessions = new ArrayList<OidcSession>();
        ArrayList<KeyValuePair> pingLogoutUriList = new ArrayList<KeyValuePair>();
        ArrayList<KeyValuePair> oidcLogoutUriList = new ArrayList<KeyValuePair>();
        this.makeOidcLogoutUrlList(issuedOidcSessions, terminatedSessions, pingLogoutUriList, oidcLogoutUriList);
        this.params.put("oidcEndpointList", pingLogoutUriList);
        this.params.put("oidcFCLogoutEndpointList", oidcLogoutUriList);
        result.setIssuedOidcSessions(terminatedSessions);
        Collection<PartnerSessionGroup> wsFedIdpPartnerSessionGroups = this.groupAndUnregisterWsFedIdpPartnerSessions(registered.keySet());
        Map<String, String> wsFedIdpSignoutUrlList = this.makeWsFedIdpSignoutUrlList(wsFedIdpPartnerSessionGroups);
        this.params.put(KEY_WSF_IDPLIST, wsFedIdpSignoutUrlList);
        result.setIssuedWsFedIdpSessions(wsFedIdpPartnerSessionGroups);
        return result;
    }

    protected Collection<PartnerSessionGroup> groupAndUnregisterWsFedIdpPartnerSessions(Collection<IdpHashableAuthnBean> beans) {
        HashMap<String, PartnerSessionGroup> entityIdToSessionGroup = new HashMap<String, PartnerSessionGroup>();
        for (IdpHashableAuthnBean bean : beans) {
            if (!bean.getAuthnSourceKey().getType().equals((Object)AuthnSourceKey.AuthnSourceType.IDP_CONN)) continue;
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
            if (idpConn == null || !idpConn.getProtocol().equals(Protocol.WSFED) || !idpConnBean.isDoLogout()) continue;
            PartnerSessionGroup group = (PartnerSessionGroup)entityIdToSessionGroup.get(idpConn.getEntityId());
            if (group == null) {
                group = new PartnerSessionGroup(idpConn.getEntityId(), idpConnBean.getVirtualServerId(), idpConnBean.getNameId(), false);
                entityIdToSessionGroup.put(idpConn.getEntityId(), group);
            }
            IdpSessionRegistrySupport.setBeansInvalidForLogout(Collections.singleton(idpConnBean));
        }
        return entityIdToSessionGroup.values();
    }

    protected Map<String, String> makeWsFedSpSignoutCleanupUrlList(Collection<WebSsoSession> issuedWsFedSessions) {
        HashMap<String, String> wsFedSignoutCleanupUrlList = new HashMap<String, String>();
        ArrayList<String> assertionsToUnregister = new ArrayList<String>();
        for (WebSsoSession session : issuedWsFedSessions) {
            assertionsToUnregister.add(session.getAssertionId());
            String spEntityId = session.getEntityId();
            SpConnection spConnectionMetadata = this.metadataDirectory.getSpConnectionMetadata(spEntityId);
            Endpoint endpoint = spConnectionMetadata.getPreferredSingleLogoutService();
            HashMap<String, String> cleanupCmd = new HashMap<String, String>();
            cleanupCmd.put("wa", "wsignoutcleanup1.0");
            String url = Util.appendQueryParams(endpoint.getFullLocation(), cleanupCmd);
            wsFedSignoutCleanupUrlList.put(spEntityId, url);
        }
        IdpSessionRegistrySupport.unregisterSessions(assertionsToUnregister);
        return wsFedSignoutCleanupUrlList;
    }

    protected Map<String, String> makeWsFedIdpSignoutUrlList(Collection<PartnerSessionGroup> groups) {
        HashMap<String, String> wsFedSignoutCleanupUrlList = new HashMap<String, String>();
        for (PartnerSessionGroup group : groups) {
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnection(group.getEntityId(), false);
            if (idpConn == null) continue;
            Endpoint endpoint = idpConn.getPreferredSingleLogoutService();
            HashMap<String, String> signOutCmd = new HashMap<String, String>();
            signOutCmd.put("wa", "wsignout1.0");
            String url = Util.appendQueryParams(endpoint.getFullLocation(), signOutCmd);
            wsFedSignoutCleanupUrlList.put(group.getEntityId(), url);
        }
        return wsFedSignoutCleanupUrlList;
    }

    protected void logWsFedOidcLogoutUrls() {
        for (Map.Entry<String, String> entry : this.getWsFedIdpSignoutUrlList().entrySet()) {
            log.debug((Object)("Sending WS-Fed Signout request to " + entry.getKey() + " at " + entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.getWsFedSpSignoutCleanupUrlList().entrySet()) {
            log.debug((Object)("Sending WS-Fed SignoutCleanup request to " + entry.getKey() + " at " + entry.getValue()));
        }
        if (log.isDebugEnabled()) {
            ArrayList<String> oidcEndpoints = new ArrayList<String>();
            for (KeyValuePair pair : this.getOidcLogoutUrlList()) {
                oidcEndpoints.add(pair.getValue());
            }
            for (KeyValuePair pair : this.getOidcFCLogoutUrlList()) {
                oidcEndpoints.add(pair.getValue());
            }
            log.debug((Object)("Logging out OIDC client endpoints, sending requests to [" + StringUtils.join(oidcEndpoints, (String)", ") + "]"));
        }
    }

    protected void makeOidcLogoutUrlList(Map<IdpHashableAuthnBean, List<OidcSession>> oidcSessions, List<OidcSession> terminatedSessions, List<KeyValuePair> pingLogoutUrls, List<KeyValuePair> oidcLogoutUrls) {
        String paLogoutEndpointPath = this.getPALogoutEndpointPath();
        ClientManager clientManager = MgmtFactory.getClientManager();
        for (Map.Entry<IdpHashableAuthnBean, List<OidcSession>> entry : oidcSessions.entrySet()) {
            LinkedHashSet<String> pingLogoutUris = new LinkedHashSet<String>();
            LinkedHashSet<String> oidcLogoutUris = new LinkedHashSet<String>();
            ArrayList<OidcSession> sessionsToUnregister = new ArrayList<OidcSession>();
            for (OidcSession session : entry.getValue()) {
                Client client = clientManager.getCachedClient(session.getClientId());
                if (client == null) continue;
                if (client.getLogoutMode() == ClientLogoutMode.PING_FRONT_CHANNEL) {
                    if (client.isPingAccessLogoutCapable() && session.getBaseUrl() != null) {
                        pingLogoutUris.add(session.getBaseUrl() + paLogoutEndpointPath);
                    }
                    if (!Util.isEmpty(client.getLogoutUris())) {
                        pingLogoutUris.addAll(client.getLogoutUris());
                    }
                    sessionsToUnregister.add(session);
                    continue;
                }
                if (client.getLogoutMode() != ClientLogoutMode.OIDC_FRONT_CHANNEL || Util.isEmpty(client.getLogoutUris())) continue;
                for (String logoutUri : client.getLogoutUris()) {
                    URL logoutUrl = this.buildOidcFrontChannelLogoutUrl(logoutUri, session);
                    if (logoutUrl == null) continue;
                    oidcLogoutUris.add(logoutUrl.toString());
                }
                sessionsToUnregister.add(session);
            }
            this.addLogoutUris(pingLogoutUrls, pingLogoutUris);
            this.addLogoutUris(oidcLogoutUrls, oidcLogoutUris);
            if (sessionsToUnregister.isEmpty()) continue;
            IdpSessionRegistrySupport.unregisterSessions(entry.getKey(), sessionsToUnregister);
            terminatedSessions.addAll(sessionsToUnregister);
        }
    }

    private void addLogoutUris(List<KeyValuePair> result, Set<String> logoutUris) {
        for (String logoutUri : logoutUris) {
            try {
                result.add(new KeyValuePair(new URL(logoutUri).getHost(), logoutUri));
            }
            catch (MalformedURLException e) {
                log.error((Object)("Invalid logout URI: " + logoutUri), (Throwable)e);
            }
        }
    }

    private URL buildOidcFrontChannelLogoutUrl(String logoutUri, OidcSession session) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("sid", session.getOidcSession().getExtendedSri());
        requestParams.put("iss", session.getOidcSession().getIssuer());
        try {
            URIBuilder urlBuilder = new URIBuilder(logoutUri);
            requestParams.forEach((arg_0, arg_1) -> ((URIBuilder)urlBuilder).addParameter(arg_0, arg_1));
            return urlBuilder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error((Object)("Unable to build OIDC front-channel logout URL. logoutUri : " + logoutUri + ", sid : " + session.getOidcSession().getExtendedSri() + ", iss : " + session.getOidcSession().getIssuer()), (Throwable)e);
            return null;
        }
    }

    protected void logIdpWsFedSessions(SessionInfo sessionInfo) {
        if (!Util.isEmpty(sessionInfo.getIssuedWsFedIdpSessions())) {
            for (PartnerSessionGroup sessionGroup : sessionInfo.getIssuedWsFedIdpSessions()) {
                this.sloSupport.securityAuditLog(sessionGroup, Protocol.WSFED, null);
            }
        }
    }

    protected String getPALogoutEndpointPath() {
        ConfigStore configStore = ConfigStoreFarm.getConfig(BaseSloTemplateRenderer.class);
        return configStore.getStringValue("PALogoutEndpointPath", "/pa/oidc/logout.png");
    }

    protected class SessionInfo {
        private Map<IdpHashableAuthnBean, Collection<Session>> issuedSessions;
        private List<WebSsoSession> issuedWsFedSpSessions;
        private Collection<PartnerSessionGroup> issuedWsFedIdpSessions;
        private List<OidcSession> issuedOidcSessions;

        protected SessionInfo() {
        }

        public Map<IdpHashableAuthnBean, Collection<Session>> getIssuedSessions() {
            return this.issuedSessions;
        }

        public void setIssuedSessions(Map<IdpHashableAuthnBean, Collection<Session>> issuedSessions) {
            this.issuedSessions = issuedSessions;
        }

        public List<WebSsoSession> getIssuedWsFedSpSessions() {
            return this.issuedWsFedSpSessions;
        }

        public void setIssuedWsFedSpSessions(List<WebSsoSession> issuedWsFedSessions) {
            this.issuedWsFedSpSessions = issuedWsFedSessions;
        }

        public Collection<PartnerSessionGroup> getIssuedWsFedIdpSessions() {
            return this.issuedWsFedIdpSessions;
        }

        public void setIssuedWsFedIdpSessions(Collection<PartnerSessionGroup> issuedWsFedSessions) {
            this.issuedWsFedIdpSessions = issuedWsFedSessions;
        }

        public List<OidcSession> getIssuedOidcSessions() {
            return this.issuedOidcSessions;
        }

        public void setIssuedOidcSessions(List<OidcSession> issuedOidcSessions) {
            this.issuedOidcSessions = issuedOidcSessions;
        }
    }

    public static class KeyValuePair
    implements Serializable {
        private String key;
        private String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

