/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResponseCreator;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.SSORespStarter;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateSsoResponse
implements ResponseCreator {
    private static final Log log = LogFactory.getLog(CreateSsoResponse.class);
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final Map<Protocol, SSORespStarter> starters = new EnumMap<Protocol, SSORespStarter>(Protocol.class);
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final String[] PARTNER_PARAM_NAMES = new String[]{"PartnerSpId", "PARTNER"};
    private final String[] TARGET_PARAM_NAMES = new String[]{"TargetResource", "TARGET"};

    @Override
    public OutMessageContext process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InMessageContext inMsgCtx = new InMessageContext(Role.SP);
        inMsgCtx.setUnsolicitedResponse(true);
        String errResource = ProprietaryURLParams.getParam(request, "InErrorResource");
        inMsgCtx.setInErrorResource(errResource);
        SpConnection spConnection = null;
        String partnerSpId = null;
        try {
            partnerSpId = ProprietaryURLParams.getParam(request, this.PARTNER_PARAM_NAMES);
        }
        catch (InvalidRequestParameterException invalidRequestParameterException) {
            // empty catch block
        }
        String targetResource = ProprietaryURLParams.getParam(request, "TargetResource", "TARGET");
        if (StringUtils.isBlank((String)partnerSpId)) {
            if (StringUtils.isBlank((String)targetResource)) {
                String[] errorDetailParameters = new String[]{Arrays.toString(this.PARTNER_PARAM_NAMES), Arrays.toString(this.TARGET_PARAM_NAMES), request.getRequestURL().toString()};
                throw new InvalidRequestParameterException(Arrays.toString(this.PARTNER_PARAM_NAMES) + " or " + Arrays.toString(this.TARGET_PARAM_NAMES) + " are required for invoking: " + request.getRequestURL(), "errorDetail.createSsoResponse.missingRequiredParameter.targetResource", errorDetailParameters);
            }
            if (this.config.getBooleanValue("allow-sp-lookup-by-target", true)) {
                spConnection = this.metadataDirectory.getByTargetUrl(targetResource);
            }
            if (spConnection == null) {
                String[] errorDetailParameters = new String[]{"PartnerSpId", "TargetResource", "TARGET", targetResource};
                throw new InvalidRequestParameterException("PartnerSpId parameter was not specified and we were unable to deduce the partner SP from the TargetResource / TARGET parameter (" + LogGuard.encode(targetResource) + ")", "errorDetail.createSsoResponse.partnerSpNotFound", errorDetailParameters);
            }
        } else if (spConnection == null) {
            spConnection = MetadataSupport.getSpConnection(partnerSpId);
        }
        LicenseManager.checkLicenseForConnection(spConnection);
        inMsgCtx.setEntityId(spConnection.getEntityId());
        String virtualServerId = VirtualIdentityUtil.resolve(spConnection, request).getVirtualEntityId(DomainMode.RUNTIME);
        inMsgCtx.setVirtualServerId(virtualServerId);
        IdpAuditLogger.setVirtualServerId(virtualServerId);
        if (StringUtils.isBlank((String)targetResource) && spConnection.hasDefaultTargetResource()) {
            targetResource = spConnection.getDefaultTargetResource();
        }
        inMsgCtx.setTargetResource(targetResource);
        Protocol protocol = spConnection.getProtocol();
        SSORespStarter ssoRespStarter = this.starters.get(protocol);
        if (ssoRespStarter == null) {
            throw new ProcessRuntimeException("Local support not enabled for protocol " + protocol);
        }
        return ssoRespStarter.process(inMsgCtx, request, response, spConnection, targetResource);
    }

    private void redirectToErrorResource(String inErrorResource, HttpServletResponse resp) throws IOException {
        try {
            TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
            redirectValidationMgr.validateInErrorResource(inErrorResource);
            resp.sendRedirect(inErrorResource);
        }
        catch (InvalidRedirectValidationException invalidRedirectValidationException) {
            // empty catch block
        }
    }

    private static void logFailure(String partnerSpId, Exception e) {
        AuditLogger.setStatus("failure");
        IdpAuditLogger.setEvent("SSO");
        AuditLogger.setPartnerId(partnerSpId);
        AuditLogger.setDescription(e.getMessage());
        IdpAuditLogger.log(e.getMessage());
    }

    public void setSsoRespStarter(Protocol protocol, SSORespStarter starter) {
        this.starters.put(protocol, starter);
    }
}

