/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import com.pingidentity.sdk.AuthnAdapterResponse;
import java.util.Calendar;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;

public class IdpAuditLogger
extends AuditLogger {
    private static final Log log = LogFactory.getLog(IdpAuditLogger.class);
    public static final String EVENT_SESSION_REVOKED = "SRI_REVOKED";
    public static final String EVENT_SESSION_QUOTA_EXCEEDED = "SESSION_QUOTA_EXCEEDED";
    public static final String EVENT_SESSION_DELETED = "AUTHN_SESSIONS_DELETED";
    public static final String EVENT_AUTHN_SOURCE_SESSION_DELETED = "AUTHN_SOURCE_SESSION_DELETED";
    public static final String USER_KEY_AND_SRI_ASSOCIATED = "USER_KEY_AND_SRI_ASSOCIATED";

    public static void log(String msg) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"IdP");
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, msg);
        IdpAuditLogger.checkUpdateTransactionCounters();
        TrackingIdSupport.createUserCrossReference();
    }

    public static void logAuthnAttempt(String msg, AuthnAdapterResponse.AUTHN_STATUS status) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"IdP");
        switch (status) {
            case SUCCESS: {
                IdpAuditLogger.setStatus("success");
                break;
            }
            case FAILURE: {
                IdpAuditLogger.setStatus("failure");
                break;
            }
            default: {
                IdpAuditLogger.setStatus("inprogress");
            }
        }
        IdpAuditLogger.setEvent("AUTHN_ATTEMPT");
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, msg);
        TrackingIdSupport.createUserCrossReference();
    }

    public static void setPartnerId(String partnerId) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)partnerId);
        SpConnection connection = MgmtFactory.getMetadataDirectory().getSpConnection(partnerId, false);
        if (connection != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)connection.getName());
        }
    }

    public static void logAuthnSession(String msg, AuthnSessionEvent event, IdpHashableAuthnBean idpHashableAuthnBean) {
        if (idpHashableAuthnBean != null) {
            String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
            String backupAdapterId = ThreadContext.get((String)AuditLogger.MDC_KEY.ADAPTER_INSTANCE_ID.toString());
            String backupAuthnSrcId = ThreadContext.get((String)AuditLogger.MDC_KEY.AUTHN_SOURCE_ID.toString());
            String backupRole = ThreadContext.get((String)AuditLogger.MDC_KEY.ROLE.toString());
            IdpAuditLogger.setAuthnSourceId(idpHashableAuthnBean.getAuthnSourceKey());
            long expiry = AuthnSessionSettings.getSessionExpiryTimeMillis(idpHashableAuthnBean, Calendar.getInstance().getTimeInMillis());
            IdpAuditLogger.setAuthnSessionExpiry(expiry);
            IdpAuditLogger.setRole("IdP");
            IdpAuditLogger.updateResponseTime();
            switch (event) {
                case EVENT_AUTHN_SESSION_CREATED: {
                    if (!idpHashableAuthnBean.isValidForSso()) break;
                    IdpAuditLogger.setEvent(event.toString());
                    IdpAuditLogger.log(log, msg);
                    break;
                }
                case EVENT_AUTHN_SESSION_USE_EXISTING: {
                    IdpAuditLogger.setEvent(event.toString());
                    IdpAuditLogger.log(log, msg);
                    break;
                }
            }
            ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
            ThreadContext.put((String)AuditLogger.MDC_KEY.ADAPTER_INSTANCE_ID.toString(), (String)backupAdapterId);
            ThreadContext.put((String)AuditLogger.MDC_KEY.AUTHN_SOURCE_ID.toString(), (String)backupAuthnSrcId);
            ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)backupRole);
            IdpAuditLogger.cleanupAuthnSessionMdcFields();
        }
    }

    public static void logSessionAssociatedToUniqueUserKey(ExtendedSri extendedSri, String uniqueUserKey, String msg) {
        String backupSri = ThreadContext.get((String)AuditLogger.MDC_KEY.SRI.toString());
        String backupSessionGroupId = ThreadContext.get((String)AuditLogger.MDC_KEY.SESSION_GROUP_ID.toString());
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        String backupRole = ThreadContext.get((String)AuditLogger.MDC_KEY.ROLE.toString());
        IdpAuditLogger.setEvent(USER_KEY_AND_SRI_ASSOCIATED);
        IdpAuditLogger.setRole("IdP");
        IdpAuditLogger.setExtendedSri(extendedSri);
        IdpAuditLogger.setUniqueUserKey(uniqueUserKey);
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, msg);
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)backupRole);
        ThreadContext.put((String)AuditLogger.MDC_KEY.SRI.toString(), (String)backupSri);
        ThreadContext.put((String)AuditLogger.MDC_KEY.SESSION_GROUP_ID.toString(), (String)backupSessionGroupId);
        ThreadContext.remove((String)AuditLogger.MDC_KEY.RESPONSE_TIME.toString());
    }

    public static void logSessionRevocationByUserKey(ExtendedSri extendedSri, String uniqueUserKey, String msg) {
        String backupSri = ThreadContext.get((String)AuditLogger.MDC_KEY.SRI.toString());
        String backupSessionGroupId = ThreadContext.get((String)AuditLogger.MDC_KEY.SESSION_GROUP_ID.toString());
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        String backupRole = ThreadContext.get((String)AuditLogger.MDC_KEY.ROLE.toString());
        IdpAuditLogger.setEvent(EVENT_SESSION_REVOKED);
        IdpAuditLogger.setRole("IdP");
        IdpAuditLogger.setExtendedSri(extendedSri);
        IdpAuditLogger.setUniqueUserKey(uniqueUserKey);
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, msg);
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)backupRole);
        ThreadContext.put((String)AuditLogger.MDC_KEY.SRI.toString(), (String)backupSri);
        ThreadContext.put((String)AuditLogger.MDC_KEY.SESSION_GROUP_ID.toString(), (String)backupSessionGroupId);
        ThreadContext.remove((String)AuditLogger.MDC_KEY.RESPONSE_TIME.toString());
        if (StringUtils.isNotBlank((String)uniqueUserKey)) {
            IdpAuditLogger.clearUniqueUserKey();
        }
    }

    public static void logSessionRevocation(String source) {
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        String backupRole = ThreadContext.get((String)AuditLogger.MDC_KEY.ROLE.toString());
        IdpAuditLogger.setEvent(EVENT_SESSION_REVOKED);
        IdpAuditLogger.setRole("IdP");
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, "Revocation of session from " + source);
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)backupRole);
        IdpAuditLogger.cleanupAuthnSessionMdcFields();
    }

    public static void logSessionQuotaExceeded() {
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        String backupRole = ThreadContext.get((String)AuditLogger.MDC_KEY.ROLE.toString());
        IdpAuditLogger.setEvent(EVENT_SESSION_QUOTA_EXCEEDED);
        IdpAuditLogger.setRole("IdP");
        IdpAuditLogger.updateResponseTime();
        IdpAuditLogger.log(log, "Session quota exceeded.");
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)backupRole);
        IdpAuditLogger.cleanupAuthnSessionMdcFields();
    }

    public static void logSessionDeleted() {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"IdP");
        IdpAuditLogger.updateResponseTime();
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        IdpAuditLogger.setEvent(EVENT_SESSION_DELETED);
        IdpAuditLogger.log(log, "User session deleted");
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
    }

    public static void logAuthnSourceSessionDeleted(ExtendedSri extendedSri, AuthnSourceKey authnSourceKey, String message) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"IdP");
        IdpAuditLogger.updateResponseTime();
        String backupEvent = ThreadContext.get((String)AuditLogger.MDC_KEY.EVENT.toString());
        String backupSri = ThreadContext.get((String)AuditLogger.MDC_KEY.SRI.toString());
        String adapterId = ThreadContext.get((String)AuditLogger.MDC_KEY.ADAPTER_INSTANCE_ID.toString());
        String authnSourceId = ThreadContext.get((String)AuditLogger.MDC_KEY.AUTHN_SOURCE_ID.toString());
        IdpAuditLogger.setEvent(EVENT_AUTHN_SOURCE_SESSION_DELETED);
        IdpAuditLogger.setExtendedSri(extendedSri);
        IdpAuditLogger.setAuthnSourceId(authnSourceKey);
        IdpAuditLogger.log(log, message);
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)backupEvent);
        ThreadContext.put((String)AuditLogger.MDC_KEY.SRI.toString(), (String)backupSri);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ADAPTER_INSTANCE_ID.toString(), (String)adapterId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.AUTHN_SOURCE_ID.toString(), (String)authnSourceId);
    }

    private static void cleanupAuthnSessionMdcFields() {
        ThreadContext.remove((String)AuditLogger.MDC_KEY.AUTHN_SESS_EXPIRY.toString());
        ThreadContext.remove((String)AuditLogger.MDC_KEY.RESPONSE_TIME.toString());
    }

    private static void setAuthnSessionExpiry(long expiryTimeMilliseconds) {
        Calendar expiry = Calendar.getInstance();
        expiry.setTimeInMillis(expiryTimeMilliseconds);
        ThreadContext.put((String)AuditLogger.MDC_KEY.AUTHN_SESS_EXPIRY.toString(), (String)IdpAuditLogger.getDateFormat().format(expiry.getTime()));
    }

    public static void setUniqueUserKeyAuditLogFields(Collection<String> uniqueUserKeys) {
        if (CollectionUtils.isNotEmpty(uniqueUserKeys)) {
            String firstUniqueUserKey = uniqueUserKeys.iterator().next();
            IdpAuditLogger.setUniqueUserKey(firstUniqueUserKey);
        }
    }

    public static enum AuthnSessionEvent {
        EVENT_AUTHN_SESSION_CREATED("AUTHN_SESSION_CREATED"),
        EVENT_AUTHN_SESSION_USE_EXISTING("AUTHN_SESSION_USED");

        private final String logEventName;

        private AuthnSessionEvent(String logEventName) {
            this.logEventName = logEventName;
        }

        public String toString() {
            return this.logEventName;
        }
    }
}

