/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import java.util.List;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;

public class IdpAuditLoggerSupport {
    private static IdpAuditLoggerSupport instance = new IdpAuditLoggerSupport();

    public static IdpAuditLoggerSupport getInstance() {
        return instance;
    }

    public void constructAuditId(IdpAuthenticationResult authnResult) {
        List<String> uniqueKeyFields = authnResult.getPseudonymAttributeNames();
        if (uniqueKeyFields != null && !uniqueKeyFields.isEmpty()) {
            Object uniqueId = null;
            AttributeMap authnIdentifiers = authnResult.getPseudonymAttributeSource();
            boolean first = true;
            for (String idFld : uniqueKeyFields) {
                AttributeValue authnId = (AttributeValue)authnIdentifiers.get((Object)idFld);
                if (authnId == null) continue;
                String authnIdStr = authnId.sensitiveToString();
                uniqueId = first ? authnIdStr : (String)uniqueId + "." + authnIdStr;
                first = false;
            }
            if (uniqueId != null) {
                IdpAuditLogger.setUserName(uniqueId);
            }
        }
    }
}

