/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.util.log.AttributeMap;

public class IdpAuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IdpHashableAuthnBean[] authnBeans;
    private final AttributeMap authnAttrs;
    private final boolean isFromAuthnSelectionApc;
    private final String sourceMappingId;

    public IdpAuthenticationResult(IdpHashableAuthnBean[] authnBeans, AttributeMap authnAttrs, boolean isFromAuthnSelectionApc, String sourceMappingId) {
        this.authnBeans = authnBeans;
        this.authnAttrs = authnAttrs;
        this.isFromAuthnSelectionApc = isFromAuthnSelectionApc;
        this.sourceMappingId = sourceMappingId;
    }

    public IdpHashableAuthnBean[] getAuthnBeans() {
        return this.authnBeans;
    }

    public AttributeMap getAuthnAttrs() {
        return this.authnAttrs;
    }

    public List<String> getPseudonymAttributeNames() {
        if (this.isFromAuthnSelectionApc) {
            return Collections.singletonList("subject");
        }
        AuthnSourceKey authnSourceKey = this.getLastAuthnSourceKey();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            ArrayList<String> pseudoAttrNames = new ArrayList<String>();
            pseudoAttrNames.add(AssertionMapKeys.getNameIdValueKey());
            return pseudoAttrNames;
        }
        IdpAuthnAdapterInstance instance = MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstance(authnSourceKey.getId());
        return instance.getUniqueKeyFields();
    }

    public AttributeMap getPseudonymAttributeSource() {
        if (this.isFromAuthnSelectionApc) {
            return this.authnAttrs;
        }
        AuthnSourceKey authnSourceKey = this.getLastAuthnSourceKey();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
            Map<String, Object> assertionAttrs = this.authnBeans[this.authnBeans.length - 1].getAuthnIdentifiersMap();
            if (assertionAttrs instanceof AttributeMap) {
                return (AttributeMap)assertionAttrs;
            }
            AuthnSourceSupport support = new AuthnSourceSupport();
            return support.convertAuthnIds(authnSourceKey, assertionAttrs);
        }
        return this.authnAttrs;
    }

    public AdapterAuthnSourceKey getMappedAdapterKey() {
        if (this.isFromAuthnSelectionApc) {
            return null;
        }
        AuthnSourceKey authnSourceKey = this.getLastAuthnSourceKey();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            return (AdapterAuthnSourceKey)authnSourceKey;
        }
        return null;
    }

    public IdpConnHashableAuthnBean getMappedIdpConnBean() {
        if (this.isFromAuthnSelectionApc) {
            return null;
        }
        if (this.authnBeans == null || this.authnBeans.length == 0) {
            return null;
        }
        IdpHashableAuthnBean lastBean = this.authnBeans[this.authnBeans.length - 1];
        if (lastBean instanceof IdpConnHashableAuthnBean) {
            return (IdpConnHashableAuthnBean)lastBean;
        }
        return null;
    }

    public boolean isFromAuthnSelectionApc() {
        return this.isFromAuthnSelectionApc;
    }

    public String getSourceMappingId() {
        return this.sourceMappingId;
    }

    public AuthnSourceKey getLastAuthnSourceKey() {
        return ArrayUtils.isEmpty((Object[])this.authnBeans) ? null : this.authnBeans[this.authnBeans.length - 1].getAuthnSourceKey();
    }
}

