/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.SloConfirmationPrompt;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateSloRequest
extends ResumableRequestCreatorBase
implements SloHandler {
    private static final String KEY_PROCESSING_STAGE = "processingStage";
    private static final String KEY_REQUEST_STATE_REF = "requestStateRef";
    private static final String KEY_OVERALL_RESULT = "overallResult";
    private static final String KEY_PROBLEMS = "problems";
    private final org.sourceid.saml20.profiles.sp.SLOSupport spSloSupport = new org.sourceid.saml20.profiles.sp.SLOSupport();
    private final SLOSupport idpSloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.addTrackedParams(req, params);
        this.setStage(params, ProcessingStage.CHECKING_FOR_SESSIONS);
        params.put(KEY_OVERALL_RESULT, true);
        String targetResource = ProprietaryURLParams.getParam(req, "TargetResource");
        String inErrorResource = ProprietaryURLParams.getParam(req, "InErrorResource");
        if (targetResource == null) {
            targetResource = this.localMetaData.getApplicationURL("sp.after.slo");
        }
        OutMessageContext outMsgCtx = new OutMessageContext(Role.IDP);
        outMsgCtx.setBinding(req.getParameter("Binding"));
        outMsgCtx.setTargetResource(targetResource);
        outMsgCtx.setInErrorResource(inErrorResource);
        this.resume(outMsgCtx, req, resp, params);
        return outMsgCtx;
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        boolean suspend = false;
        while (!suspend) {
            switch (this.getStage(params)) {
                case CHECKING_FOR_SESSIONS: {
                    if (this.checkForSessions(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_IDP_SIDE);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_IDP_SIDE: {
                    if (this.logoutIdpSide(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.DONE);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case WAITING_FOR_IDP_SIDE_RESPONSE: {
                    this.handleIdpSideLogoutResponse(req, resp, params);
                    this.setStage(params, ProcessingStage.DONE);
                    break;
                }
                case DONE: {
                    this.finishLogout(reqMsgCtx, req, resp, params);
                    suspend = true;
                }
            }
        }
        return null;
    }

    private boolean checkDisplayConfirmationPrompt(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws ResponseTemplateRendererException {
        SloConfirmationPrompt prompt = new SloConfirmationPrompt();
        return prompt.checkDisplayConfirmationPrompt(req, resp, false, () -> this.saveState(req, resp, outMsgCtx, params));
    }

    protected boolean checkForSessions(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (this.checkDisplayConfirmationPrompt(outMsgCtx, req, resp, params)) {
            return false;
        }
        IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
        if (!this.hasAnySessions(req, resp)) {
            this.log.debug((Object)"No sessions found in memory for SLO");
        } else {
            this.idpSloSupport.checkRevokeUserSession(req, resp);
        }
        IdpSessionRegistrySupport.setSessionBeansInvalidForSso(Arrays.asList(StateMgmtFactory.getLocalSessionId(req, resp)));
        IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
        return true;
    }

    protected boolean hasAnySessions(HttpServletRequest req, HttpServletResponse resp) {
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        Map<SpHashableAuthnBean, WebSsoSession> beansAndSessions = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(localSessionId);
        return !beansAndSessions.isEmpty() || IdpSessionRegistrySupport.hasSessions(req, resp);
    }

    protected boolean logoutIdpSide(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (!this.hasAnySessions(req, resp)) {
            return true;
        }
        String requestStateRef = this.idpSloSupport.makeRequestStateRef();
        params.put(KEY_REQUEST_STATE_REF, requestStateRef);
        this.setStage(params, ProcessingStage.WAITING_FOR_IDP_SIDE_RESPONSE);
        String resumeUrl = this.saveState(req, resp, null, outMsgCtx, params);
        this.idpSloSupport.sendStartSloRequest(new StartSloRequest(requestStateRef, resumeUrl, false, outMsgCtx.getBinding(), null, false), req, resp);
        return false;
    }

    protected void handleIdpSideLogoutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) {
        String requestStateRef = (String)params.get(KEY_REQUEST_STATE_REF);
        StartSloResponse response = this.idpSloSupport.getStartSloResponse(requestStateRef, req, resp);
        if (response == null) {
            throw new ProcessRuntimeException("Expected StartSloResponse but none was found");
        }
        params.put(KEY_OVERALL_RESULT, response.getOverallResult() && (Boolean)params.get(KEY_OVERALL_RESULT) != false);
        params.put(KEY_PROBLEMS, new ArrayList<String>(response.getProblems()));
    }

    protected void finishLogout(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        boolean overallResult = (Boolean)params.get(KEY_OVERALL_RESULT);
        List problems = (List)params.get(KEY_PROBLEMS);
        if (overallResult) {
            this.spSloSupport.localLogoutSuccess(reqMsgCtx.getTargetResource(), req, resp, null);
        } else {
            this.spSloSupport.handleError(reqMsgCtx.getTargetResource(), reqMsgCtx.getInErrorResource(), req, resp, problems, null, null);
        }
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    private ProcessingStage getStage(Map<String, Object> params) {
        return (ProcessingStage)((Object)params.get(KEY_PROCESSING_STAGE));
    }

    private void setStage(Map<String, Object> params, ProcessingStage stage) {
        params.put(KEY_PROCESSING_STAGE, (Object)stage);
    }

    static enum ProcessingStage {
        CHECKING_FOR_SESSIONS,
        LOGGING_OUT_IDP_SIDE,
        WAITING_FOR_IDP_SIDE_RESPONSE,
        DONE;

    }
}

