/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.profiles.sp.InternalAttributeQuerier;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.ProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ProvisioningProcessorManager;
import org.sourceid.websso.profiles.sp.provisioning.commands.ProvisionLdap;
import org.sourceid.websso.profiles.sp.provisioning.commands.ProvisionSqlServer;
import org.sourceid.websso.profiles.sp.provisioning.commands.TestProvisionSqlServer;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.invokers.LdapProvisioningInvoker;
import org.sourceid.websso.profiles.sp.provisioning.invokers.SqlServerProvisioningInvoker;

public class ProvisioningProcessor {
    private static final Log log = LogFactory.getLog(ProvisioningProcessor.class);
    private static final String ERROR_PROVISIONING = "There was an error provisioning the user.";

    public void process(HttpServletRequest req, HttpServletResponse resp, IdpConnection idpConnection, AttributeMap assertionAttributes) {
        AttributeMap attrsFromIdp;
        UserProvisioning userProvisioning = idpConnection.getUserProvisioning();
        if (userProvisioning == null) {
            log.debug((Object)("Provisioning not enabled for: " + idpConnection.getEntityId() + " - " + idpConnection.getName()));
            return;
        }
        if (userProvisioning.isDoAttributeQuery()) {
            AttributeMap additionalAttributes = this.doAttributeQuery(req, resp, idpConnection, assertionAttributes);
            attrsFromIdp = this.mergeAttributes(assertionAttributes, additionalAttributes);
        } else {
            attrsFromIdp = assertionAttributes;
        }
        boolean status = false;
        Exception cause = null;
        String exceptionMessage = "SSO aborted due to failure in user provisioning.";
        try {
            status = this.doProvisioning(userProvisioning, attrsFromIdp);
        }
        catch (Exception ex) {
            if (ex instanceof AuthorizationException) {
                exceptionMessage = "";
            } else if (ex instanceof AttrLookupException) {
                exceptionMessage = "There was a problem translating the attribute values.";
            }
            cause = ex;
            status = false;
        }
        if (!status && userProvisioning.getErrorHandling() == UserProvisioning.ErrorHandlingType.AbortSSO) {
            throw new ProvisioningException(exceptionMessage, cause);
        }
        if (!status) {
            log.info((Object)"User provisioning failed.  SSO is configured to continue.");
        }
    }

    public boolean doProvisioning(UserProvisioning userProvisioning, AttributeMap attrsFromIdp) throws SaaSProvisioningException, AttrLookupException, AuthorizationException {
        AttributeMap evaledUserProvisioningAttrs = ProvisioningProcessor.doTranslation(userProvisioning, attrsFromIdp);
        AttributeSource attrSource = userProvisioning.getAttributeSource();
        DataSource dataSrc = attrSource.getDataSource();
        ProvisioningProcessorManager manager = ProvisioningProcessorManager.getInstance();
        ExpressProvisioningProcessor expressProvisioningProcessor = null;
        try {
            expressProvisioningProcessor = manager.getProvisioningProcessor(dataSrc, userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        }
        catch (SaaSProvisioningException ex) {
            log.error((Object)ex.getMessages().get(0));
            throw ex;
        }
        if (DataSource.DSType.LDAP.getName().equals(dataSrc.getDataSourceType())) {
            LdapProvisioningInvoker invoker = new LdapProvisioningInvoker(new ProvisionLdap(expressProvisioningProcessor));
            return invoker.insert();
        }
        if (DataSource.DSType.JDBC.getName().equals(dataSrc.getDataSourceType())) {
            SqlServerProvisioningInvoker invoker = new SqlServerProvisioningInvoker(new ProvisionSqlServer(expressProvisioningProcessor), new TestProvisionSqlServer(expressProvisioningProcessor));
            return invoker.insert();
        }
        log.error((Object)"There was an error provisioning the user. The datasource is not supported.");
        return false;
    }

    private AttributeMap doAttributeQuery(HttpServletRequest req, HttpServletResponse resp, IdpConnection idpConnection, AttributeMap assertionAttributes) {
        InternalAttributeQuerier querier = new InternalAttributeQuerier();
        AttributeMap attrQueryAttributes = querier.query(req, resp, idpConnection, assertionAttributes);
        return attrQueryAttributes;
    }

    public static AttributeMap doTranslation(AttributeMapping userProvisioning, AttributeMap attrs) throws AttrLookupException, AuthorizationException {
        UserProvisioning tempUserProvisioning = new UserProvisioning();
        tempUserProvisioning.setAttributeMap2(userProvisioning.getAttributeMapping());
        tempUserProvisioning.setTokenAuthorizationIssuanceCriteria(userProvisioning.getTokenAuthorizationIssuanceCriteria());
        return tempUserProvisioning.executeMapping(attrs, userProvisioning.getAttributeMapping().keySet());
    }

    private AttributeMap mergeAttributes(AttributeMap attribMap1, AttributeMap attribMap2) {
        AttributeMap attributes = new AttributeMap();
        if (attribMap1 != null && !attribMap1.isEmpty()) {
            attributes.putAll((Map)attribMap1);
        }
        if (attribMap2 != null && !attribMap2.isEmpty()) {
            attributes.putAll((Map)attribMap2);
        }
        return attributes;
    }
}

