/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.HandleAuthnRequest;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.profiles.idp.authn.AuthnSelectionResult;
import org.sourceid.saml20.protocol.StatusResponseTypeUtil;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.profiles.idp.HandleRST;

public class ResumeRequestFromResponseSupport {
    private static Log log = LogFactory.getLog(ResumeRequestFromResponseSupport.class);

    public static State getSupplementalFedHubState(OutMessageContext ssoReqOutMsgCtx) {
        return ssoReqOutMsgCtx != null ? (State)ssoReqOutMsgCtx.getSupplementalContext("FederationHubOriginalAuthnReqState") : null;
    }

    public static boolean isAuthnSelectionInProgress(Map<String, Object> stateParams) {
        AuthnSelectionResult authnSelectionResult;
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        if (policyTreeState != null && (authnSelectionResult = policyTreeState.getPreviousAuthnSelResult()) != null) {
            return AuthnSelectionResult.ResultType.IN_PROGRESS.equals((Object)authnSelectionResult.getResultType());
        }
        return false;
    }

    public static ResumeRequestFromAuthnResponseHandler createFedHubRequestHandler(OutMessageContext reqOutCtx) throws AuthnAdapterException {
        String spConnId = reqOutCtx.getEntityId();
        SpConnection spConn = MgmtFactory.getConnectionManager().getSpConnection(spConnId);
        if (spConn == null) {
            throw new AuthnAdapterException("Sp connection '" + spConnId + "' doesn't exist");
        }
        switch (spConn.getProtocol()) {
            case SAML20: {
                return new HandleAuthnRequest();
            }
            case WSFED: {
                return new HandleRST(null);
            }
            case SAML10: 
            case SAML11: {
                return new CreateResponse();
            }
        }
        throw new AuthnAdapterException("The " + spConn.getProtocol() + "' protocol is not supported for fed hub");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean handleException(Throwable t, ErrorCodeException errCodeEx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (errCodeEx != null) {
            t = errCodeEx instanceof Throwable ? (Throwable)((Object)errCodeEx) : new Exception(errCodeEx.getErrorDetail());
        }
        boolean handled = false;
        State state = ResumeRequestFromResponseSupport.getSupplementalFedHubState(reqMsgCtx);
        if (state == null) return handled;
        if (state.getInMsgCtx() != null && state.getInMsgCtx().getBinding() == null) {
            Object var7_7 = null;
        } else {
            InMessageContext inMessageContext = state.getInMsgCtx();
        }
        Map<String, Object> origStateParams = state.getParameters();
        if (ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(origStateParams)) {
            String rrfrhClassName = (String)origStateParams.get("OriginalResumeHandlerClassName");
            ResumeRequestFromAuthnResponseHandler resumeHandler = MetaDataFactory.getLocalMetaData().getProfileProcessFactory().getResumeRequestFromAuthnResponseHandler(rrfrhClassName);
            if (resumeHandler == null) throw new IllegalStateException("Unable to find the original handler to resume");
            String originalResumePath = (String)origStateParams.get("authnPolicyInitialResumeUrl");
            StateSupport.overridePath(req, originalResumePath);
            origStateParams.put("AuthnSelectionTreeIdpConnComplete", Boolean.TRUE);
            resumeHandler.resumeAuthn(state.getInMsgCtx(), req, resp, state.getOutMsgCtx(), origStateParams);
            BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
            try {
                void var7_9;
                bindingSvc.transportResponse(req, resp, (InMessageContext)var7_9, state.getOutMsgCtx());
                return true;
            }
            catch (BindingException | RedirectException | RenderPageException e) {
                log.error((Object)"Unable for transport response:", (Throwable)e);
            }
            return handled;
        } else {
            if (state.getOutMsgCtx() == null) return handled;
            return ResumeRequestFromResponseSupport.forwardErrorToSp(t, req, resp, state.getInMsgCtx(), state.getOutMsgCtx());
        }
    }

    public static boolean resumeRequestFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ResumeRequestFromResponseHandler delegate = ResumeRequestFromResponseSupport.getResumeFromResponseHandler(reqMsgCtx);
        if (delegate == null) {
            return false;
        }
        State originalState = ResumeRequestFromResponseSupport.getOriginalState(reqMsgCtx);
        String originalPath = ResumeRequestFromResponseSupport.getOriginalPath(reqMsgCtx);
        StateSupport.overridePath(req, originalPath);
        delegate.resumeFromResponse(responseObject, respMsgCtx, reqMsgCtx, req, resp, originalState);
        return true;
    }

    public static void registerResumeFromResponseHandler(OutMessageContext reqMsgCtx, Class<? extends ResumeRequestFromResponseHandler> delegate, HttpServletRequest req, State originalState) {
        ResumeRequestFromResponseSupport.setResumeFromResponseHandler(reqMsgCtx, delegate);
        ResumeRequestFromResponseSupport.setOriginalPath(reqMsgCtx, StateSupport.getPathWithOverride(req));
        ResumeRequestFromResponseSupport.setOriginalState(reqMsgCtx, originalState);
    }

    public static ResumeRequestFromResponseHandler getResumeFromResponseHandler(OutMessageContext reqMsgCtx) {
        if (reqMsgCtx == null) {
            return null;
        }
        String className = (String)reqMsgCtx.getSupplementalContext("ResumeFromResponseHandlerClassName");
        if (className == null) {
            return null;
        }
        ResumeRequestFromResponseHandler handler = MetaDataFactory.getLocalMetaData().getProfileProcessFactory().getResumeFromResponseHandler(className);
        if (handler == null) {
            throw new ProcessRuntimeException("No ResumeFromResponseHandler registered for class name " + className);
        }
        return handler;
    }

    public static void setResumeFromResponseHandler(OutMessageContext reqMsgCtx, Class<? extends ResumeRequestFromResponseHandler> delegate) {
        reqMsgCtx.setSupplementalContext("ResumeFromResponseHandlerClassName", delegate.getName());
    }

    public static void setOriginalPath(OutMessageContext reqMsgCtx, String pathWithContextRoot) {
        reqMsgCtx.setSupplementalContext("ResumeFromResponseHandlerOriginalPath", pathWithContextRoot);
    }

    public static String getOriginalPath(OutMessageContext reqMsgCtx) {
        return (String)reqMsgCtx.getSupplementalContext("ResumeFromResponseHandlerOriginalPath");
    }

    public static void setOriginalState(OutMessageContext reqMsgCtx, State state) {
        reqMsgCtx.setSupplementalContext("ResumeFromResponseHandlerOriginalState", state);
    }

    public static State getOriginalState(OutMessageContext reqMsgCtx) {
        return (State)reqMsgCtx.getSupplementalContext("ResumeFromResponseHandlerOriginalState");
    }

    private static boolean forwardErrorToSp(Throwable e, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext reqOutMsgCtx) {
        SpConnection spConn = MgmtFactory.getConnectionManager().getSpConnection(reqOutMsgCtx.getEntityId());
        if (spConn != null) {
            switch (spConn.getProtocol()) {
                case SAML20: {
                    if (reqInMsgCtx.isUnsolicitedResponse()) {
                        return false;
                    }
                    StatusResponseException statusRespEx = new StatusResponseException(TopLevelStatusCode.RESPONDER, e.getMessage(), e);
                    String virtualServerId = VirtualIdentityUtil.resolve(reqInMsgCtx).getVirtualEntityId(DomainMode.RUNTIME);
                    StatusResponseTypeUtil.writeStatus(statusRespEx, reqInMsgCtx.getXmlObject(), reqOutMsgCtx.getXmlObject(), virtualServerId);
                    BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
                    try {
                        bindingSvc.transportResponse(req, resp, reqInMsgCtx, reqOutMsgCtx);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Could not forward error response to Sp. Writing error to response.", (Throwable)e2);
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        log.warn((Object)("Could not forward error response to Sp. No Sp Connection was found with the entity id '" + reqOutMsgCtx.getEntityId() + "'"));
        return false;
    }
}

