/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import com.pingidentity.c2ccontract.C2cContract;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;

public class SpAuditLogger
extends AuditLogger {
    private static Log log = LogFactory.getLog(SpAuditLogger.class);

    public static void log(String msg) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"SP");
        SpAuditLogger.updateResponseTime();
        SpAuditLogger.log(log, msg);
        SpAuditLogger.checkUpdateTransactionCounters();
        TrackingIdSupport.createUserCrossReference();
    }

    public static String getAttributesAsString(Map<String, String> attributes) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                keyValue.add(key + "=" + attributes.get(key));
            }
        }
        return Util.listToDelimString(keyValue, ",");
    }

    public static String getAttributeValuesAsString(AttributeMap attributes) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                keyValue.add(key + "=" + attributes.getSingleValue(key));
            }
        }
        return Util.listToDelimString(keyValue, ",");
    }

    public static void setTargetSessionId(TargetSessionId targetSessionId) {
        if (targetSessionId != null && targetSessionId.getId() != null) {
            if (targetSessionId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
                SpAuditLogger.setAdapterInstanceId(targetSessionId.getId());
            }
            ThreadContext.put((String)AuditLogger.MDC_KEY.TARGET_SESSION_ID.toString(), (String)targetSessionId.getId());
        }
    }

    public static void setTargetSessionIds(Collection<TargetSessionId> targetSessionIds) {
        if (targetSessionIds == null) {
            return;
        }
        LinkedList<String> adapterIds = new LinkedList<String>();
        LinkedList<String> ids = new LinkedList<String>();
        for (TargetSessionId targetSessionId : targetSessionIds) {
            if (targetSessionId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
                adapterIds.add(targetSessionId.getId());
            }
            ids.add(targetSessionId.getId());
        }
        if (!ids.isEmpty()) {
            if (ids.size() == 1) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.TARGET_SESSION_ID.toString(), (String)((String)ids.get(0)));
            } else {
                ThreadContext.put((String)AuditLogger.MDC_KEY.TARGET_SESSION_ID.toString(), (String)((Object)ids).toString());
            }
        }
        if (!adapterIds.isEmpty()) {
            if (adapterIds.size() == 1) {
                SpAuditLogger.setAdapterInstanceId((String)adapterIds.get(0));
            } else {
                SpAuditLogger.setAdapterInstanceId(((Object)adapterIds).toString());
            }
        }
    }

    public static void logAuthnAttempt(String msg) {
        String origPolicyName = AuditLogger.getPolicyName();
        String origFragmentName = AuditLogger.getFragmentName();
        AuditLogger.clearPoliciesUsed();
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"SP");
        SpAuditLogger.setEvent("AUTHN_REQUEST");
        SpAuditLogger.setStatus("inprogress");
        SpAuditLogger.updateResponseTime();
        SpAuditLogger.log(log, msg);
        TrackingIdSupport.createUserCrossReference();
        AuditLogger.setPolicyName(origPolicyName);
        AuditLogger.setFragmentName(origFragmentName);
    }

    public static void setPartnerId(String partnerId) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)partnerId);
        IdpConnection connection = MgmtFactory.getMetadataDirectory().getIdpConnection(partnerId, false);
        if (connection != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)connection.getName());
        } else {
            C2cContract contract = MgmtFactory.getC2cContractManager().getContract(partnerId);
            if (contract != null) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)contract.getName());
            }
        }
    }
}

