/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import com.pingidentity.common.util.JDBCHelper;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressDeprovisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlStatementUtil;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;

public class SqlServerExpressDeprovisioningProcessor
extends JdbcExpressDeprovisioningProcessor {
    private static final Log log = LogFactory.getLog(SqlServerExpressDeprovisioningProcessor.class);

    public SqlServerExpressDeprovisioningProcessor(String selectedDatasourceName, String schemaName, String tableName, ResultInfo uniqueIdColumn) {
        super(selectedDatasourceName, schemaName, tableName, uniqueIdColumn);
    }

    @Override
    protected void doTestDeleteUser(String selectedDatasourceName, String schemaName, String tableName, ResultInfo uniqueIdColumn) throws SaaSProvisioningException {
        this.rollbackAll(selectedDatasourceName, schemaName, tableName, uniqueIdColumn);
    }

    private void rollbackAll(String selectedDatasourceName, String schemaName, String tableName, ResultInfo uniqueIdColumn) throws SaaSProvisioningException {
        log.debug((Object)"Deleting JDBC test inserts...");
        ArrayList<String> errors = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(selectedDatasourceName, this);
            String deleteStatement = SqlStatementUtil.createDeleteStatement(schemaName, tableName, uniqueIdColumn);
            PreparedStatement ps = jdbcHelper.getPreparedStatement(deleteStatement);
            SqlServerDataTypeCoersionHandler chain = new SqlServerDataTypeCoersionHandler(ps, JdbcExpressProvisioningProcessor.OPERATION.DELETE);
            ArrayList<ResultInfo> uniqueIdList = new ArrayList<ResultInfo>();
            uniqueIdList.add(uniqueIdColumn);
            if (!((JdbcDataHandler)chain).process(uniqueIdList, errors)) {
                ps.close();
                throw new SaaSProvisioningException(errors);
            }
            int rowsAffected = ps.executeUpdate();
            ps.close();
            log.debug((Object)("Delete successful. " + rowsAffected + " rows deleted."));
        }
        catch (Exception e) {
            String rollbackError = "There was an exception trying to delete from the database: " + e;
            log.error((Object)rollbackError);
            errors.add(rollbackError);
            throw new SaaSProvisioningException(errors);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }
}

