/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import com.pingidentity.common.util.JDBCHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlStatementUtil;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.handlers.IllegalCharacterSqlInjectionHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.KeywordSqlInjectionHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.NullableColumnAssignmentHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;

@SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The reported findbug issue is a requirement for this method")
public class SqlServerExpressProvisioningProcessor
extends JdbcExpressProvisioningProcessor {
    private static final Log log = LogFactory.getLog(SqlServerExpressProvisioningProcessor.class);
    public static final int SQL_VARIANT = -150;
    public static final int NCHAR = -15;
    public static final int NCHAR_2 = -8;
    public static final int NVARCHAR = -9;
    public static final int NVARCHARMAX_AND_NTEXT = -16;

    public SqlServerExpressProvisioningProcessor(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp, List<ResultInfo> columns) {
        super(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp, columns);
    }

    @Override
    protected synchronized List<String> doInsert(List<ResultInfo> listToInsert) throws SaaSProvisioningException {
        PreparedStatement ps = null;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> returnColumns = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            JdbcDataHandler preprocessChain = new IllegalCharacterSqlInjectionHandler().setNext(new KeywordSqlInjectionHandler());
            if (!preprocessChain.process(listToInsert, errors)) {
                log.error((Object)("Insert into '" + this.getTableName() + "' failed!"));
                throw new SaaSProvisioningException(errors);
            }
            jdbcHelper = new JDBCHelper(this.getSelectedDatasourceName(), this);
            String insertStatement = SqlStatementUtil.createInsertPreparedStatement(this.getSchemaName(), this.getTableName(), listToInsert);
            ps = jdbcHelper.getPreparedStatement(insertStatement, true);
            this.preparedStatementProcessing(ps, errors, listToInsert);
            if (!errors.isEmpty()) {
                log.error((Object)("Insert into '" + this.getTableName() + "' failed!"));
                throw new SaaSProvisioningException(errors);
            }
            ps.setQueryTimeout(10);
            ps.executeUpdate();
            if (this.tableHasSystemManagedColumns(listToInsert)) {
                ResultSet rs = ps.getGeneratedKeys();
                List<String> systemManagedColumns = this.getListOfSystemManagedColumns(listToInsert);
                int i = 0;
                while (rs.next()) {
                    BigDecimal systemGeneratedKey = rs.getBigDecimal(i + 1);
                    if (systemGeneratedKey != null) {
                        returnColumns.add(systemManagedColumns.get(i) + "-" + systemGeneratedKey.toString());
                    }
                    ++i;
                }
            }
            ps.close();
            log.debug((Object)("The insert into '" + this.getTableName() + "' was successful."));
        }
        catch (SQLException | NamingException se) {
            String error = "There was an exception trying to insert into the database: " + se;
            log.error((Object)error);
            errors.add(error);
            throw new SaaSProvisioningException(errors);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return returnColumns;
    }

    protected void preparedStatementProcessing(Statement ps, List<String> errors, List<ResultInfo> listToInsert) throws SQLException {
        JdbcDataHandler chain = new NullableColumnAssignmentHandler().setNext(new SqlServerDataTypeCoersionHandler(ps, JdbcExpressProvisioningProcessor.OPERATION.INSERT));
        if (!chain.process(listToInsert, errors)) {
            ps.close();
        }
    }

    @Override
    protected synchronized List<String> doUpdate(List<ResultInfo> listToUpdate) throws SaaSProvisioningException {
        PreparedStatement ps = null;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> returnColumns = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            String updateStatement;
            JdbcDataHandler preprocessChain = new IllegalCharacterSqlInjectionHandler().setNext(new KeywordSqlInjectionHandler());
            if (!preprocessChain.process(listToUpdate, errors)) {
                log.error((Object)("Update of '" + this.getTableName() + "' failed!"));
                throw new SaaSProvisioningException(errors);
            }
            jdbcHelper = new JDBCHelper(this.getSelectedDatasourceName(), this);
            ps = jdbcHelper.getPreparedStatement(updateStatement = SqlStatementUtil.createUpdateStatement(this.getSchemaName(), this.getTableName(), listToUpdate, this.getUniqueColumnId()));
            JdbcDataHandler chain = new NullableColumnAssignmentHandler().setNext(new SqlServerDataTypeCoersionHandler(ps, JdbcExpressProvisioningProcessor.OPERATION.INSERT));
            if (!chain.process(listToUpdate, errors)) {
                ps.close();
                log.error((Object)("Update of '" + this.getTableName() + "' failed!"));
                throw new SaaSProvisioningException(errors);
            }
            ps.executeUpdate();
            ps.setQueryTimeout(10);
            ps.close();
            log.debug((Object)("Update of '" + this.getTableName() + "' was successful."));
        }
        catch (Exception e) {
            String error = "There was an exception trying to update the database: " + e;
            log.error((Object)error);
            errors.add(error);
            throw new SaaSProvisioningException(errors);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return returnColumns;
    }

    @Override
    protected List<String> loadResultInfoColumnList(List<ResultInfo> columns, AttributeMap evaledUserProvisioningAttrs) throws SaaSProvisioningException {
        ArrayList<String> errors = new ArrayList<String>();
        for (ResultInfo info : columns) {
            String columnName = info.getColumnName();
            if (!StringUtils.isEmpty((String)columnName)) {
                AttributeValue v = (AttributeValue)evaledUserProvisioningAttrs.get((Object)columnName);
                if (v == null || StringUtils.isEmpty((String)v.getValue()) && !this.isEmptyStringValuePermitted(info)) continue;
                info.setValue(v.getValue());
                continue;
            }
            String error = this.getProvisioningErrorWithoutColumnName();
            log.error((Object)error);
            errors.add(error);
        }
        if (!errors.isEmpty()) {
            throw new SaaSProvisioningException(errors);
        }
        return errors;
    }

    protected String getProvisioningErrorWithColumnName(String columnName) {
        return "There was a problem resolving one of the provisioning columns.  Column: " + columnName + " does not have a value.";
    }

    protected String getProvisioningErrorWithoutColumnName() {
        return "There was a problem resolving one of the provisioning columns.  Column Name is null";
    }

    private boolean isEmptyStringValuePermitted(ResultInfo info) {
        if (info.isSystemManaged()) {
            return true;
        }
        switch (info.getDataType()) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return true;
            }
        }
        return false;
    }

    private boolean tableHasSystemManagedColumns(List<ResultInfo> listToInsert) {
        return !this.getListOfSystemManagedColumns(listToInsert).isEmpty();
    }

    private List<String> getListOfSystemManagedColumns(List<ResultInfo> listToInsert) {
        ArrayList<String> l = new ArrayList<String>();
        for (ResultInfo info : listToInsert) {
            if (!info.isSystemManaged()) continue;
            l.add(Integer.toString(info.getOrdinalPosition()));
        }
        return l;
    }
}

