/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.PathResource;

public final class AssetsDefaultServlet
extends DefaultServlet {
    private static final String PF_ASSETS_PATH_NAME = "pf.assets.path";

    public String getInitParameter(String name) {
        if ("resourceBase".equals(name)) {
            Object resourceBase = this.getServletContext().getInitParameter(PF_ASSETS_PATH_NAME);
            if (StringUtils.isBlank((String)resourceBase)) {
                resourceBase = System.getProperty("pf.server.default.dir") + "/conf/template";
            }
            return AssetsDefaultServlet.aliasCheckAndUpdateIfNeeded((String)resourceBase);
        }
        return super.getInitParameter(name);
    }

    private static String aliasCheckAndUpdateIfNeeded(String resourceBase) {
        if (File.separatorChar != '/') {
            return resourceBase;
        }
        try (PathResource resource = new PathResource(new File(resourceBase));){
            if (resource.getAliasPath() == null) {
                String string = resourceBase;
                return string;
            }
            String string = resource.getAliasPath().equals(resource.getPath()) ? resourceBase : resource.getAliasPath().toString();
            return string;
        }
    }
}

