/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.pingidentity.configservice.ConfigUpdateCoordinator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.profiles.ProfileProcessMgmtService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;

public abstract class EnforcerServletBase
extends HttpServlet {
    private static final long serialVersionUID = -3835547149863792426L;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String REQUEST_TIMESTAMP_ATTR_NAME = "com.pingidentity.appserver.REQUEST_TIMESTAMP";
    private static final String FAILED_TX_MSG = "Your transaction has failed. Please notify your system administrator.";
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    protected final BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    protected final ProfileProcessMgmtService processMgmtSvc = GlobalRegistry.getService(ProfileProcessMgmtService.class);
    private final ConfigUpdateCoordinator configUpdateCoordinator = ConfigUpdateCoordinator.getInstance();

    public abstract void process(HttpServletRequest var1, HttpServletResponse var2, boolean var3) throws ServletException, IOException, RenderPageException, RedirectException, NoSuchProcessException, HttpStatusCodeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkProcess(HttpServletRequest request, HttpServletResponse response, boolean isPost) throws ServletException, IOException {
        if (LicenseManager.getStatus().isLockdownRuntime()) {
            this.log.warn((Object)"Your PingFederate server is in violation of the license terms.  No more transactions will be processed.");
            response.sendError(503, FAILED_TX_MSG);
        } else {
            this.configUpdateCoordinator.incrementRequestsInFlight(request);
            try {
                this.checkSessionRevoked(request, response);
                StateMgmtFactory.saveSessionReplicationInfo(request, response);
                TrackingIdSupport.setTrackingIdInThreadContext(request, response);
                TransactionIdSupport.createTransactionId();
                AuditLogger.init();
                if (request.getAttribute(REQUEST_TIMESTAMP_ATTR_NAME) != null) {
                    AuditLogger.setRequestStartTime((Long)request.getAttribute(REQUEST_TIMESTAMP_ATTR_NAME));
                }
                AuditLogger.setRemoteAddress(request.getRemoteAddr());
                this.process(request, response, isPost);
            }
            catch (RenderPageException e) {
                this.handleRenderPageEx(e, request, response);
            }
            catch (RedirectException e) {
                this.handleRedirectEx(e, response);
            }
            catch (HttpStatusCodeException e) {
                this.handleStatusCodeEx(response, e);
            }
            catch (NoSuchProcessException e) {
                response.sendError(404);
            }
            finally {
                StateMgmtFactory.removeSessionReplicationInfo();
                AuditLogger.cleanup();
                this.configUpdateCoordinator.decrementRequestsInFlight(request);
            }
        }
    }

    protected void checkSessionRevoked(HttpServletRequest req, HttpServletResponse resp) {
        StateMgmtFactory.checkSessionRevoked(req, resp);
    }

    private void handleStatusCodeEx(HttpServletResponse response, HttpStatusCodeException e) throws IOException {
        Map<String, String> headers = e.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            response.addHeader(entry.getKey(), entry.getValue());
        }
        int statusCode = e.getStatusCode();
        String message = e.getMessage();
        if (message == null) {
            response.sendError(statusCode);
        } else {
            response.sendError(statusCode, message);
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.checkProcess(req, resp, false);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.checkProcess(req, resp, true);
    }

    protected void handleRenderPageEx(RenderPageException e, HttpServletRequest req, HttpServletResponse response) throws ResponseTemplateRendererException {
        String pageTemplate = e.getPageTemplate();
        HashMap<String, Object> params = e.getParams();
        params = params == null ? new HashMap<String, Object>() : params;
        params.put("ExceptionMessage", e.getMessage());
        StringBuilder sb = new StringBuilder();
        sb.append(e).append(" - rendering ").append(pageTemplate);
        if (e.isVerboseLogOutput()) {
            sb.append(" with params: ").append(params);
            this.log.error((Object)sb, (Throwable)e);
        } else {
            this.log.info((Object)sb);
        }
        ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
        renderer.render(req, response, pageTemplate, params);
    }

    protected void handleRedirectEx(RedirectException e, HttpServletResponse response) throws IOException {
        Throwable cause = e.getCause();
        this.log.warn((Object)("RedirectException cause: " + (cause != null ? cause : e)));
        response.sendRedirect(e.getLocation());
    }

    public OAuthIssuerUtils getOAuthIssuerService() {
        return this.oAuthIssuerUtils;
    }
}

