/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.google.common.primitives.Longs;
import com.pingidentity.common.util.Base64URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class ExtendedSri {
    private String sri;
    private String groupId;
    private String encodedSeriesId;
    private String persistentSessionGroupId;
    private String extendedSri;

    public ExtendedSri(String extendedSri) throws InvalidParameterException {
        this.extendedSri = extendedSri;
        if (extendedSri == null) {
            throw new InvalidParameterException("Invalid extended SRI");
        }
        String[] parts = extendedSri.split("\\.");
        if (parts.length > 0) {
            this.sri = this.nullIfEmpty(parts[0]);
        }
        if (parts.length > 1) {
            this.groupId = this.nullIfEmpty(parts[1]);
        }
        if (parts.length > 2) {
            this.encodedSeriesId = this.nullIfEmpty(parts[2]);
        }
        if (parts.length > 3) {
            this.persistentSessionGroupId = this.nullIfEmpty(parts[3]);
        }
        if (this.sri == null || this.sri.length() != 27 || !this.isBase64String(this.sri)) {
            throw new InvalidParameterException("Invalid extended SRI");
        }
        if (this.groupId != null) {
            if (!this.isBase64String(this.groupId)) {
                throw new InvalidParameterException("Invalid extended SRI");
            }
            this.groupId = Base64URL.decodeToString((String)this.groupId, (String)StandardCharsets.UTF_8.name());
            if (this.groupId == null || this.groupId.isEmpty()) {
                throw new InvalidParameterException("Invalid extended SRI");
            }
        }
        if (this.encodedSeriesId != null && !this.isBase64String(this.encodedSeriesId)) {
            throw new InvalidParameterException("Invalid extended SRI");
        }
        if (this.persistentSessionGroupId != null && !ValidationUtil.isAlphaNumericStrict(this.persistentSessionGroupId)) {
            throw new InvalidParameterException("Invalid extended SRI");
        }
    }

    public ExtendedSri(String sri, String groupId) {
        this.sri = sri;
        this.setGroupId(groupId);
    }

    public ExtendedSri(String sri, String groupId, long seriesId) {
        this.sri = sri;
        this.setGroupId(groupId);
        this.encodedSeriesId = ExtendedSri.encodeSeriesId(seriesId);
    }

    public ExtendedSri(String sri, String groupId, long seriesId, String persistentSessionGroupId) {
        this(sri, groupId, seriesId);
        this.persistentSessionGroupId = persistentSessionGroupId;
    }

    public String getSri() {
        return this.sri;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getEncodedSeriesId() {
        return this.encodedSeriesId;
    }

    public String getPersistentSessionGroupId() {
        return this.persistentSessionGroupId;
    }

    public static String encodeSeriesId(long seriesId) {
        if (seriesId == 0L) {
            return null;
        }
        return Base64URL.encodeToString((byte[])Arrays.copyOfRange(Longs.toByteArray((long)seriesId), 5, 8));
    }

    public String getExtendedSri() {
        if (this.extendedSri != null) {
            return this.extendedSri;
        }
        String encodedGroupId = null;
        if (this.groupId != null) {
            encodedGroupId = Base64URL.encodeToString((byte[])this.groupId.getBytes(StandardCharsets.UTF_8));
        }
        this.extendedSri = String.join((CharSequence)".", this.emptyIfNull(this.sri), this.emptyIfNull(encodedGroupId), this.emptyIfNull(this.encodedSeriesId), this.emptyIfNull(this.persistentSessionGroupId));
        this.extendedSri = StringUtils.stripEnd((String)this.extendedSri, (String)".");
        return this.extendedSri;
    }

    private String emptyIfNull(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }

    private String nullIfEmpty(String val) {
        if (val == null) {
            return null;
        }
        if (val.isEmpty()) {
            return null;
        }
        return val;
    }

    private boolean isBase64String(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-' || ch == '_') continue;
            return false;
        }
        return true;
    }

    private void setGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            groupId = null;
        }
        this.groupId = groupId;
    }
}

