/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.websso.servlet.BaseSessionIdUtil;
import org.sourceid.websso.servlet.SessionIdUtil;

public class PersistentSessionIdUtil
extends BaseSessionIdUtil {
    private static final Log log = LogFactory.getLog(PersistentSessionIdUtil.class);
    private static final PersistentSessionIdUtil INSTANCE = new PersistentSessionIdUtil();
    public static final String ATTR_PREFIX = "pf.sessionid.pst";

    protected PersistentSessionIdUtil() {
        super("persistent-session-cookie-config", ATTR_PREFIX);
    }

    public static PersistentSessionIdUtil getInstance() {
        return INSTANCE;
    }

    public void setValue(HttpServletRequest request, HttpServletResponse response, String value) {
        this.writeValue(request, response, value, false);
    }

    public String hashPrimaryValue(String primaryValue) {
        return TokenUtil.digestToken(primaryValue);
    }

    @Override
    protected Map<String, AttributeValue> makeAdditionalCookieAttrs(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        String sessionId = SessionIdUtil.getInstance().getExtendedSessionId(req, resp);
        if (sessionId == null) {
            sessionId = SessionIdUtil.getInstance().getPrimaryValue(req, resp, true);
        }
        result.put("pf", new AttributeValue(sessionId));
        return result;
    }
}

