/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.PropertyInfo;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SessionReplicationInfo;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.servlet.BaseSessionIdUtil;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.PersistentSessionIdUtil;

public class SessionIdUtil
extends BaseSessionIdUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final SessionIdUtil INSTANCE = new SessionIdUtil();
    public static final String ATTR_PREFIX = "pf.sessionid";

    protected SessionIdUtil() {
        super("session-cookie-config", ATTR_PREFIX);
    }

    protected SessionIdUtil(String configFileName) {
        super(configFileName, ATTR_PREFIX);
    }

    public static SessionIdUtil getInstance() {
        return INSTANCE;
    }

    public String getSri(HttpServletRequest request, HttpServletResponse response) {
        return this.getSriFromPrimaryValue(this.getPrimaryValue(request, response));
    }

    public String getExtendedSri(HttpServletRequest request, HttpServletResponse response) {
        return this.getExtendedSriFromPrimaryValue(this.getPrimaryValue(request, response));
    }

    public String getExtendedSriV2(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        String primaryValue = this.getPrimaryValue(request, response);
        String secondaryValue = this.getSecondaryValue(request, response);
        String persistentSessionGroupId = null;
        long seriesId = 0L;
        if (secondaryValue != null && MgmtFactory.getAuthnSessionPolicyManager().hasAuthnSessionConfig()) {
            AuthnSessionInfo info = IdpSessionRegistrySupport.getAuthnSessionInfo(request, response, params);
            seriesId = info.getSessionSeriesId();
            persistentSessionGroupId = info.getPersistentSessionGroupId();
        }
        return this.makeExtendedSriV2(primaryValue, seriesId, persistentSessionGroupId);
    }

    public String getExtendedSessionId(HttpServletRequest request, HttpServletResponse response) {
        String primaryValue = this.getPrimaryValue(request, response);
        String secondaryValue = this.getSecondaryValue(request, response);
        if (secondaryValue == null) {
            return null;
        }
        return primaryValue + secondaryValue;
    }

    public String cycleExtendedSessionId(HttpServletRequest req, HttpServletResponse resp) {
        String value = resp.isCommitted() ? this.getSecondaryValue(req, resp) : this.newValue();
        String primary = this.getPrimaryValue(req, resp);
        String raw = primary + value;
        this.writeValue(req, resp, raw, false);
        return raw;
    }

    public String getSriFromPrimaryValue(String primaryValue) {
        if (primaryValue == null) {
            return null;
        }
        byte[] bytes = HashUtil.hashToBytes((String)primaryValue, (HashAlgorithm)HashAlgorithm.SHA1);
        return Base64URL.encodeToString((byte[])bytes);
    }

    public String getSriFromExtendedId(String extendedId) {
        String s = this.parsePrimaryValue(extendedId);
        return this.getSriFromPrimaryValue(s);
    }

    public String getExtendedSriFromPrimaryValue(String primaryValue) {
        return this.makeExtendedSriV2(primaryValue, 0L, null);
    }

    public String makeExtendedSriV2(String primaryValue, long seriesId, String persistentSessionGroupId) {
        if (primaryValue == null) {
            return null;
        }
        String sri = this.getSriFromPrimaryValue(primaryValue);
        return this.makeExtendedSriV2WithSri(sri, seriesId, persistentSessionGroupId);
    }

    public String makeExtendedSriV2WithSri(String sri, long seriesId, String persistentSessionGroupId) {
        String groupId = this.getNodeGroupId();
        return new ExtendedSri(sri, groupId, seriesId, persistentSessionGroupId).getExtendedSri();
    }

    public SessionReplicationInfo makeSessionReplicationInfo(HttpServletRequest req, HttpServletResponse resp) {
        return new SessionReplicationInfo(this.getPrimaryValue(req, resp), this.getExtendedSessionId(req, resp));
    }

    public String getNodeGroupId() {
        if (PropertyInfo.isAdaptiveClusteringEnabled()) {
            return StateMgmtFactory.getAdaptiveClusteringConfig().getNodeGroupId();
        }
        PreferredNodeGroup group = StateMgmtFactory.getIdpSessionRegistry().getPreferredNodeGroup();
        if (group != null) {
            return group.getGroupId();
        }
        return null;
    }

    @Override
    protected void writeValue(HttpServletRequest request, HttpServletResponse response, String value, boolean clearCookie) {
        super.writeValue(request, response, value, clearCookie);
        PersistentSessionIdUtil.getInstance().checkUpdateAdditionalCookieAttrs(request, response);
    }

    protected String getSecondaryValue(HttpServletRequest request, HttpServletResponse response) {
        return this.parseValue(this.getValue(request, response), 1);
    }

    @Override
    protected String recoverValueFromRequest(HttpServletRequest request, HttpServletResponse response) {
        Map<String, AttributeValue> attrs = PersistentSessionIdUtil.getInstance().getExtendedAttrs(request, response);
        if (attrs != null && attrs.containsKey("pf")) {
            String value = attrs.get("pf").getValue();
            this.writeValue(request, response, value, false);
            return value;
        }
        return null;
    }
}

