/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.authnapi;

import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.wrapper.AuthnApiRequestProxy;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.websso.authn.AuthnApiCookielessUtils;
import org.sourceid.websso.servlet.authnapi.AuthnApiRespProxy;

public class AuthnApiProxyFilter
extends AbstractHttpFilter {
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        AuthnApiRequestProxy proxyRequest = AuthnApiProxyFilter.getAuthnApiRequestProxy(request);
        filterChain.doFilter((ServletRequest)proxyRequest, (ServletResponse)new AuthnApiRespProxy(response));
    }

    static AuthnApiRequestProxy getAuthnApiRequestProxy(HttpServletRequest request) {
        AuthnApiCookielessUtils cookielessUtils = AuthnApiCookielessUtils.newInstance();
        boolean isCookielessHeaderPresent = cookielessUtils.isCookielessRequestHeaderPresent(request);
        if (isCookielessHeaderPresent) {
            Map<String, Cookie> cookies = cookielessUtils.getCookies(request);
            return new AuthnApiRequestProxy(request, cookies);
        }
        return new AuthnApiRequestProxy(request);
    }
}

