/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.reqparam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class ForwardedHeaderExtractor {
    private static final Log log = LogFactory.getLog(ForwardedHeaderExtractor.class);
    private static final String HTTPS_SCHEME = "https";
    private static final Pattern HOST_AND_PORT_PATTERN = Pattern.compile("([^:]+)(:[0-9]+)?");
    private MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();

    public String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = this.getForwardedHeaderValue(request, this.getClientIpHeaderName(), this.getClientIpHeaderIndex());
        return remoteAddr != null ? remoteAddr : request.getRemoteAddr();
    }

    public HostInfo getHostInfo(HttpServletRequest request) {
        HostInfo result = null;
        String host = this.getForwardedHeaderValue(request, this.getForwardedHostHeaderName(), this.getForwardedHostHeaderIndex());
        if (host != null) {
            Matcher matcher = HOST_AND_PORT_PATTERN.matcher(host);
            if (!matcher.matches()) {
                log.debug((Object)("Invalid format for forwarded host header '" + this.localMetaData.getForwardedHostHeaderName() + "': " + host));
            } else {
                String hostname = matcher.group(1);
                int port = -1;
                if (matcher.groupCount() > 1 && matcher.group(2) != null) {
                    String portString = matcher.group(2).substring(1);
                    try {
                        port = Integer.parseInt(portString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (port <= 0) {
                    port = HTTPS_SCHEME.equals(this.getScheme(request)) ? 443 : 80;
                }
                result = new HostInfo(hostname, port);
            }
        }
        if (result == null) {
            result = new HostInfo(request.getServerName(), request.getServerPort());
        }
        return result;
    }

    public String getScheme(HttpServletRequest request) {
        if (this.isProxyTerminatesHttpsConns()) {
            return HTTPS_SCHEME;
        }
        return request.getScheme();
    }

    protected String getClientIpHeaderName() {
        return this.localMetaData.getCustomGlobalHttpHeaderName();
    }

    protected LocalSettings.ForwardedHeaderIndex getClientIpHeaderIndex() {
        return this.localMetaData.getClientIpHeaderIndex();
    }

    protected String getForwardedHostHeaderName() {
        return this.localMetaData.getForwardedHostHeaderName();
    }

    protected LocalSettings.ForwardedHeaderIndex getForwardedHostHeaderIndex() {
        return this.localMetaData.getForwardedHostHeaderIndex();
    }

    protected boolean isProxyTerminatesHttpsConns() {
        return this.localMetaData.isProxyTerminatesHttpsConns();
    }

    private String getForwardedHeaderValue(HttpServletRequest request, String headerName, LocalSettings.ForwardedHeaderIndex index) {
        String result = null;
        if (StringUtils.isNotBlank((String)headerName)) {
            ArrayList<String> headerItems = new ArrayList<String>();
            for (String headerValue : Collections.list(request.getHeaders(headerName))) {
                for (String headerItem : headerValue.split(",")) {
                    headerItems.add(headerItem.trim());
                }
            }
            if (!headerItems.isEmpty()) {
                switch (index) {
                    case FIRST: {
                        result = (String)headerItems.get(0);
                        break;
                    }
                    default: {
                        result = (String)headerItems.get(headerItems.size() - 1);
                    }
                }
            }
            if (StringUtils.isBlank(result)) {
                log.debug((Object)("Reverse proxy header '" + headerName + "' is missing or the format of the header is invalid. Please check that your reverse proxy configuration matches the settings specified under System Options."));
                result = null;
            }
        }
        return result;
    }

    public class HostInfo {
        private String hostname;
        private int port;

        public HostInfo(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostName() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }
    }
}

