/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.reqparam;

import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.sourceid.servlet.streams.LengthLimitServletInputStream;
import org.sourceid.websso.servlet.reqparam.ValidationHub;

public class HttpServletReqProxy
extends HttpServletRequestWrapper {
    protected static final ValidationHub validation = new ValidationHub();
    protected HttpServletRequest request;
    private LengthLimitServletInputStream is;
    protected boolean parametersCleared = false;
    private final List<String> validatedParameters = new ArrayList<String>();

    public HttpServletReqProxy(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new LengthLimitServletInputStream(this.request.getInputStream());
        }
        return this.is;
    }

    public String getParameter(String name) {
        String result;
        if (this.parametersCleared) {
            return null;
        }
        if (this.validatedParameters.contains(name)) {
            result = this.request.getParameter(name);
        } else {
            result = validation.getParam(this.request, name);
            this.validatedParameters.add(name);
        }
        return result;
    }

    public Enumeration<String> getParameterNames() {
        if (this.parametersCleared) {
            return Collections.emptyEnumeration();
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String paramName) {
        if (this.parametersCleared) {
            return null;
        }
        return this.request.getParameterValues(paramName);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parametersCleared) {
            return Collections.emptyMap();
        }
        return this.request.getParameterMap();
    }

    public String getMethod() {
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(this.request)) {
            return "GET";
        }
        return this.request.getMethod();
    }

    public String getContentType() {
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(this.request)) {
            return null;
        }
        return this.request.getContentType();
    }

    public String toString() {
        return this.request.getRequestURI();
    }

    public void clearParameters() {
        this.parametersCleared = true;
    }
}

