/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.reqparam;

import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.AbstractValidator;
import org.sourceid.websso.servlet.reqparam.ValidationHub;

public class IntValidator
extends AbstractValidator {
    private int min;
    private int max;
    private String desc;

    @Override
    public void initialize(String args) {
        String[] parts = args.split(",");
        if (parts.length != 2) {
            throw new ProcessRuntimeException("Two arguments are expected.");
        }
        this.min = Integer.parseInt(parts[0].trim());
        this.max = Integer.parseInt(parts[1].trim());
        this.desc = "Value not an integer or outside of range (" + this.min + "," + this.max + ")";
    }

    @Override
    public void validate(String name, String value) {
        boolean valid;
        try {
            int v = Integer.parseInt(value);
            valid = v >= this.min && v <= this.max;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        ValidationHub.checkThrowIRPE(name, this.desc, valid);
    }
}

