/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.reqparam;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.AbstractValidator;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.ValidationHub;

public class UrlHostValidator
extends AbstractValidator {
    private static final String WILDCARD = "*";
    private String args;
    private Set<String> exactDomains = new HashSet<String>();
    private List<String> leadingWildcards = new ArrayList<String>();

    @Override
    public void initialize(String args) {
        String[] domains;
        for (String domain : domains = args.split(",")) {
            if (!this.isValidWhitelistEntry(domain = domain.trim().toLowerCase())) {
                throw new ProcessRuntimeException("Please provide a vaild domain name or IP address.  Domain names may start with *. to indicate a wildcard.");
            }
            if (domain.startsWith(WILDCARD)) {
                domain = domain.substring(WILDCARD.length());
                this.leadingWildcards.add(domain);
                continue;
            }
            this.exactDomains.add(domain);
        }
        this.args = args;
    }

    @Override
    public void validate(String name, String value) throws InvalidRequestParameterException {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        try {
            URL targetUrl = new URL(value);
            String host = targetUrl.getHost();
            host = host.toLowerCase();
            if (!this.exactDomains.contains(host)) {
                boolean isValid = false;
                for (String wildcardend : this.leadingWildcards) {
                    if (!host.endsWith(wildcardend)) continue;
                    isValid = true;
                    break;
                }
                ValidationHub.checkThrowIRPE(name, "The URL host doesn't match any expected hosts " + this.args, isValid);
            }
        }
        catch (MalformedURLException mal) {
            ValidationHub.throwIRPE(name, "Not a valid URL: " + mal);
        }
    }

    private boolean isValidWhitelistEntry(String entry) {
        String wildcardSequence = "*.";
        if (entry.startsWith(wildcardSequence)) {
            entry = entry.substring(wildcardSequence.length());
        }
        try {
            URI uri = new URI("http://" + entry);
            return entry.equals(uri.getHost());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

