/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.wrapper;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;

public abstract class AssertionStatus
implements Serializable {
    private XmlObject assertionXml;
    private Status status = Status.VALID;
    private List<String> remarks = new LinkedList<String>();

    protected AssertionStatus(XmlObject assertionXml) {
        this.assertionXml = assertionXml;
    }

    public XmlObject getAssertionXml() {
        return this.assertionXml;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isValid() {
        return this.status == Status.VALID;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    public void addInvalidRemark(String remark) {
        this.addRemark(remark);
        this.setStatus(Status.INVALID);
    }

    public void addRemark(String remark) {
        this.remarks.add(remark);
    }

    public int hashCode() {
        return this.assertionXml.hashCode();
    }

    public boolean equals(Object obj) {
        return this.assertionXml.equals(obj);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(2048);
        buf.append(Util.LINE_BREAK);
        buf.append("Assertion (").append(this.getAssertionId()).append(") Status: ").append((Object)this.status);
        if (!this.remarks.isEmpty()) {
            buf.append(Util.LINE_BREAK);
            buf.append("Remarks:");
            for (String remark : this.remarks) {
                buf.append(Util.LINE_BREAK);
                buf.append(remark);
            }
        }
        return buf.toString();
    }

    protected abstract String getAssertionId();

    public static enum Status {
        VALID,
        INVALID,
        INDETERMINATE;

    }
}

