/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.wrapper;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.protocol.soap11.xml.EnvelopeDocument;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.xmlbinding.assertion.impl.AssertionTypeImpl;
import org.sourceid.saml20.xmlbinding.protocol.impl.StatusCodeTypeImpl;
import org.sourceid.util.ExternalizationEncoder;

public abstract class BaseMessageContext
implements Externalizable {
    protected static final String TO_STRING_DELIM = System.getProperty("line.separator");
    protected static final String LOGGING_PARAM_DELIM = " | ";
    protected static final String PROTOCOL_STATUS_NS = "urn:oasis:names:tc:SAML:2.0:protocol";
    protected static final String SAML_2_NS = "urn:oasis:names:tc:SAML:2.0:assertion";
    protected static final String XPATH_STATUS_CODE = "declare namespace ps='urn:oasis:names:tc:SAML:2.0:protocol' .//ps:StatusCode";
    protected static final String XPATH_ID = "declare namespace s='urn:oasis:names:tc:SAML:2.0:assertion' .//s:Assertion";
    private XmlObject xmlObject;
    private transient XmlObject maskedXmlObject;
    private String relayState;
    private String entityId;
    private String virtualServerId;
    private String binding;
    private Role role;
    private Exception deferredException;
    private String targetResource;
    private String inErrorResource;
    private String adapterId;
    private String requestedUserId;
    private OAuthIssuer oauthIssuer;
    private Map<String, Object> params;
    private Set<String> maskedParams;
    protected boolean isBackChannelBinding;

    BaseMessageContext(Role role) {
        this.setRoleType(role);
    }

    public BaseMessageContext() {
    }

    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public void setXmlObject(XmlObject xmlObject) {
        this.maskedXmlObject = null;
        this.xmlObject = xmlObject;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getVirtualServerId() {
        return this.virtualServerId;
    }

    public void setVirtualServerId(String virtualServerId) {
        this.virtualServerId = virtualServerId;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public Role getRoleType() {
        return this.role;
    }

    public void setRoleType(Role role) {
        this.role = role;
    }

    public Object getObjParam(String name) {
        return this.params != null ? this.params.get(name) : null;
    }

    public <T> T getParam(String name, Class<T> type) {
        Object obj = this.getObjParam(name);
        return type.cast(obj);
    }

    public String getParam(String name) {
        Object obj = this.getObjParam(name);
        return obj == null ? null : obj.toString();
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
        this.maskedParams = new HashSet<String>();
    }

    public void setParam(String name, Object value) {
        this.setParam(name, value, false);
    }

    public void setParam(String name, Object value, boolean mask) {
        this.checkMap();
        this.params.put(name, value);
        if (mask) {
            this.maskedParams.add(name);
        } else {
            this.maskedParams.remove(name);
        }
    }

    public void setMaskedParamName(String name) {
        this.checkMap();
        this.maskedParams.add(name);
    }

    public Map<String, Object> getParams() {
        this.checkMap();
        return this.params;
    }

    public Map<String, Object> getMaskedParams() {
        this.checkMap();
        HashMap<String, Object> maskedParamMap = new HashMap<String, Object>(this.params);
        for (String maskedName : this.maskedParams) {
            if (!this.params.containsKey(maskedName)) continue;
            maskedParamMap.put(maskedName, "*****");
        }
        return maskedParamMap;
    }

    private Map<String, Object> encodeStringParamsValues(Map<String, Object> paramMap) {
        HashMap<String, Object> newParamMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            String paramName = param.getKey();
            Object paramVal = param.getValue();
            if (paramVal != null) {
                if (paramVal instanceof String[]) {
                    String valueStr = Arrays.toString(LogGuard.encode((String[])paramVal));
                    newParamMap.put(paramName, valueStr);
                } else if (paramVal instanceof String) {
                    newParamMap.put(paramName, LogGuard.encode((String)paramVal));
                }
            }
            newParamMap.putIfAbsent(paramName, paramVal);
        }
        return newParamMap;
    }

    public void checkThrowDeferredException() throws Exception {
        if (this.deferredException != null) {
            throw this.deferredException;
        }
    }

    public void setDeferredException(Exception deferredException) {
        this.deferredException = deferredException;
    }

    public String getTargetResource() {
        return this.targetResource;
    }

    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    public String getInErrorResource() {
        return this.inErrorResource;
    }

    public void setInErrorResource(String inErrorResource) {
        this.inErrorResource = inErrorResource;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    protected void setMaskedXmlObject(XmlObject maskedXmlObject) {
        this.maskedXmlObject = maskedXmlObject;
    }

    private void checkMap() {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
            this.maskedParams = new HashSet<String>();
        }
    }

    protected abstract XmlObject mask();

    public XmlObject getMaskedXml() {
        if (this.maskedXmlObject == null) {
            this.maskedXmlObject = this.mask();
        }
        return this.maskedXmlObject;
    }

    public String toString() {
        XmlObject maskedObj = this.getMaskedXml();
        String prettyXml = null;
        if (maskedObj != null) {
            XmlOptions xmlOpts = XmlBeansUtil.getXmlOptions();
            xmlOpts.setSavePrettyPrint();
            prettyXml = maskedObj.xmlText(xmlOpts);
        }
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(TO_STRING_DELIM);
        if (prettyXml != null) {
            sb.append("XML: ").append(prettyXml).append(TO_STRING_DELIM);
        }
        sb.append("entityId: ").append(this.entityId).append(" (").append((Object)this.role).append(")").append(TO_STRING_DELIM);
        sb.append("virtualServerId: ").append(this.virtualServerId).append(TO_STRING_DELIM);
        sb.append("Binding: ").append(this.binding).append(TO_STRING_DELIM);
        if (this.relayState != null) {
            sb.append("relayState: ").append(this.relayState).append(TO_STRING_DELIM);
        }
        if (this.params != null) {
            Map<String, Object> maskedParamValues = this.getMaskedParams();
            sb.append("params: ").append(this.encodeStringParamsValues(maskedParamValues)).append(TO_STRING_DELIM);
        }
        if (this.deferredException != null) {
            sb.append(this.deferredException).append(TO_STRING_DELIM);
        }
        return sb.toString();
    }

    protected AssertionTypeImpl getAssertionObj() {
        XmlObject[] obs;
        if (this.xmlObject != null && (obs = this.xmlObject.selectPath(XPATH_ID)) != null && obs.length > 0) {
            return (AssertionTypeImpl)obs[0];
        }
        return null;
    }

    public StringBuilder getStandardInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(LOGGING_PARAM_DELIM).append("Connection ID: ").append(this.entityId).append(" (").append((Object)this.role).append(")");
        sb.append(LOGGING_PARAM_DELIM).append("Virtual Server ID: ").append(this.virtualServerId);
        String msgType = null;
        String id = null;
        if (this.xmlObject != null) {
            AssertionTypeImpl ass;
            msgType = this.xmlObject.getClass().getSimpleName();
            int docLoc = msgType.indexOf("Document");
            if (docLoc == -1) {
                docLoc = msgType.length();
            }
            msgType = msgType.substring(0, docLoc);
            XmlObject[] obs = this.xmlObject.selectPath(XPATH_STATUS_CODE);
            if (obs != null && obs.length > 0) {
                sb.append(LOGGING_PARAM_DELIM).append(((StatusCodeTypeImpl)obs[0]).getValue());
            }
            if ((ass = this.getAssertionObj()) != null) {
                id = ass.getID();
            }
        }
        if (msgType != null) {
            sb.append(LOGGING_PARAM_DELIM).append(msgType);
        }
        if (id != null) {
            sb.append(LOGGING_PARAM_DELIM).append("SAML ID: ").append(id);
        }
        if (this.targetResource != null) {
            sb.append(LOGGING_PARAM_DELIM).append("Target URL: ").append(this.targetResource);
        }
        if (this.deferredException != null) {
            sb.append(LOGGING_PARAM_DELIM).append(this.deferredException);
        }
        return sb;
    }

    public StringBuilder getEnhancedInfo() {
        StringBuilder sb = new StringBuilder();
        AssertionTypeImpl ass = this.getAssertionObj();
        if (ass != null && ass.getSubject() != null && ass.getSubject().isSetNameID()) {
            sb.append(LOGGING_PARAM_DELIM).append("SAML Subject: ").append(ass.getSubject().getNameID().getStringValue());
        }
        sb.append(LOGGING_PARAM_DELIM).append(this.binding);
        if (this.relayState != null) {
            sb.append(LOGGING_PARAM_DELIM).append("RelayState: ").append(this.relayState);
        }
        return sb;
    }

    public String getFullInfo() {
        if (this.xmlObject != null) {
            EnvelopeDocument envDoc = EnvelopeDocument.Factory.newInstance();
            envDoc.addNewEnvelope().addNewBody().set(this.getMaskedXml());
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrintIndent(0);
            opts.setSavePrettyPrintOffset(0);
            String xmlEnv = envDoc.xmlText(opts);
            xmlEnv = xmlEnv.replace("\n", "").replace("\r", "");
            return LOGGING_PARAM_DELIM + xmlEnv;
        }
        return "";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xmlObject = ExternalizationEncoder.readXmlObject(in);
        this.relayState = ExternalizationEncoder.readString(in);
        this.entityId = ExternalizationEncoder.readString(in);
        this.virtualServerId = ExternalizationEncoder.readString(in);
        this.binding = ExternalizationEncoder.readString(in);
        this.role = ExternalizationEncoder.readEnum(in, Role.class);
        this.targetResource = ExternalizationEncoder.readString(in);
        this.inErrorResource = ExternalizationEncoder.readString(in);
        this.adapterId = ExternalizationEncoder.readString(in);
        this.params = ExternalizationEncoder.readStringObjectMap(in);
        this.maskedParams = ExternalizationEncoder.readStringSet(in);
        this.requestedUserId = ExternalizationEncoder.readString(in);
        this.oauthIssuer = (OAuthIssuer)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizationEncoder.writeXmlObject(out, this.xmlObject);
        ExternalizationEncoder.writeString(out, this.relayState);
        ExternalizationEncoder.writeString(out, this.entityId);
        ExternalizationEncoder.writeString(out, this.virtualServerId);
        ExternalizationEncoder.writeString(out, this.binding);
        ExternalizationEncoder.writeEnum(out, Role.class, this.role);
        ExternalizationEncoder.writeString(out, this.targetResource);
        ExternalizationEncoder.writeString(out, this.inErrorResource);
        ExternalizationEncoder.writeString(out, this.adapterId);
        ExternalizationEncoder.writeStringObjectMap(out, this.params);
        ExternalizationEncoder.writeStringSet(out, this.maskedParams);
        ExternalizationEncoder.writeString(out, this.requestedUserId);
        out.writeObject(this.oauthIssuer);
    }

    public String getStatusCodeUri() {
        XmlObject[] obs;
        if (this.xmlObject != null && (obs = this.xmlObject.selectPath(XPATH_STATUS_CODE)) != null && obs.length > 0) {
            StatusCodeTypeImpl statusCodeType = (StatusCodeTypeImpl)obs[0];
            return statusCodeType.getValue();
        }
        return null;
    }

    public String getRequestedUserId() {
        return this.requestedUserId;
    }

    public void setRequestedUserId(String userId) {
        this.requestedUserId = userId;
    }

    public OAuthIssuer getOauthIssuer() {
        return this.oauthIssuer;
    }

    public void setOauthIssuer(OAuthIssuer oauthIssuer) {
        this.oauthIssuer = oauthIssuer;
    }

    public boolean isBackChannelBinding() {
        return this.isBackChannelBinding;
    }

    public void setBackChannelBinding(boolean backChannelBinding) {
        this.isBackChannelBinding = backChannelBinding;
    }
}

