/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.domain;

import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.wsfed.domain.WSFedConnectionWrapper;

public class WsFedIdPConnectionWrapper
extends WSFedConnectionWrapper {
    private final IdpConnection idpConnection;

    public WsFedIdPConnectionWrapper(IdpConnection idpConnection) {
        this.idpConnection = idpConnection;
    }

    @Override
    public void setWsFedEndpointUrl(String url) {
        Endpoint endpoint = new Endpoint("wsfed:prp:http:get", url);
        EndpointGroup ssoSvcs = new EndpointGroup(endpoint);
        this.idpConnection.setSingleSignOnServices(ssoSvcs);
        this.setSignOutUrlForWsFed(url);
    }

    @Override
    public String getWsFedEndpointUrl() {
        String endpointUrl = null;
        EndpointGroup ssoSvcs = this.idpConnection.getSingleSignOnServices();
        if (ssoSvcs != null) {
            Endpoint primaryEndpoint = ssoSvcs.getPrimaryEndpoint();
            endpointUrl = primaryEndpoint != null ? primaryEndpoint.getLocation() : null;
        }
        return endpointUrl;
    }

    @Override
    public IdpConnection getConn() {
        return this.idpConnection;
    }
}

