/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.TokenTypeDocument;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.profiles.idp.ClaimsWsTrust12Handler;
import org.sourceid.wsfed.profiles.idp.ClaimsWsTrust13Handler;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.xmlsoap.schemas.ws.x2004.x09.policy.AppliesToDocument;

public abstract class ClaimsUtil {
    private static final String PARAM_HEADER = "header";
    private static final String PARAM_EXCEPTION_MSG = "exception_msg";
    private static final String PARAM_Server = "server";
    private static final String PARAM_ERROR = "error";
    private static final String PARAM_ERROR_DETAIL = "errorDetail";
    static final ConfigStore configStore = ConfigStoreFarm.getConfig(ClaimsUtil.class);
    static final String USER_REQUEST_SECURITY_TOKEN_RESPONSE_COLLECTION = "useRequestSecurityTokenResponseCollection";
    static final String MICROSOFT_O365_ENTITY_ID = "urn:federation:MicrosoftOnline";
    static final String WSFED_IDP_EXCEPTION_TEMPLATE = "sourceid-wsfed-idp-exception-template.html";

    public static ClaimsUtil getDefaultInstance() {
        return new ClaimsWsTrust12Handler();
    }

    public static ClaimsUtil getInstance(String wsTrustVersion) {
        if (WSTrustVersion.v13.getVersion().equals(wsTrustVersion)) {
            return new ClaimsWsTrust13Handler();
        }
        return new ClaimsWsTrust12Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendElement(XmlObject container, XmlObject element) {
        XmlCursor containerCursor = null;
        XmlCursor elementCursor = null;
        try {
            containerCursor = container.newCursor();
            while (containerCursor.hasNextToken()) {
                containerCursor.toNextToken();
            }
            containerCursor.toPrevToken();
            elementCursor = element.newCursor();
            elementCursor.copyXmlContents(containerCursor);
        }
        catch (Throwable throwable) {
            XmlBeansUtil.disposeCursor(elementCursor);
            XmlBeansUtil.disposeCursor(containerCursor);
            throw throwable;
        }
        XmlBeansUtil.disposeCursor(elementCursor);
        XmlBeansUtil.disposeCursor(containerCursor);
    }

    void appendAppliesElement(String partnerId, XmlObject rstrType) {
        AppliesToDocument appliesToDoc = AppliesToDocument.Factory.newInstance();
        AppliesToDocument.AppliesTo appliesTo = appliesToDoc.addNewAppliesTo();
        XmlObject endPointRefDoc = this.getEndpointReferenceDocument(partnerId);
        this.appendElement((XmlObject)appliesTo, endPointRefDoc);
        this.appendElement(rstrType, (XmlObject)appliesToDoc);
    }

    abstract XmlObject getEndpointReferenceDocument(String var1);

    public static void handleException(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put(PARAM_HEADER, "Exception");
        String msg = e.getMessage();
        if (msg == null) {
            msg = "none";
        }
        Throwable cause = e.getCause();
        String error = "";
        String errorDetail = "";
        boolean errorCodeException = cause instanceof ErrorCodeException;
        if (errorCodeException) {
            error = ((ErrorCodeException)((Object)cause)).getErrorCode();
            errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", ((ErrorCodeException)((Object)cause)).getErrorDetail(), ((ErrorCodeException)((Object)cause)).getErrorDetailParameters());
            msg = "";
        }
        objMap.put(PARAM_ERROR, error);
        objMap.put(PARAM_ERROR_DETAIL, errorDetail);
        objMap.put(PARAM_EXCEPTION_MSG, msg);
        objMap.put(PARAM_Server, req.getServerName());
        try {
            SsoRespSupport ssoRespSupport = new SsoRespSupport();
            AuthenticationFailed authnFailedModel = ssoRespSupport.makeAuthnFailedModel(req, resp, error, errorDetail, e, null);
            if (!ssoRespSupport.checkRedirectAuthnApiApplication(req, resp, stateParams, authnFailedModel)) {
                ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
                renderer.render(req, resp, WSFED_IDP_EXCEPTION_TEMPLATE, objMap);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception in rendering a message. ", e);
        }
    }

    void appendTokenTypeElement(XmlObject rstrType, String tokenTypeUri) {
        TokenTypeDocument tokenTypeDoc = TokenTypeDocument.Factory.newInstance();
        tokenTypeDoc.setTokenType(tokenTypeUri);
        this.appendElement(rstrType, (XmlObject)tokenTypeDoc);
    }

    public abstract XmlObject assembleRSTR(XmlObject var1, String var2, boolean var3);

    public abstract String getResponseTypeName();
}

