/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.saml11.xml.AssertionDocument;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.wsfed.profiles.idp.ClaimsUtil;
import org.sourceid.wstrust.model.WsTrustTokenType;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.xmlsoap.schemas.ws.x2004.x08.addressing.AttributedURI;
import org.xmlsoap.schemas.ws.x2004.x08.addressing.EndpointReferenceDocument;
import org.xmlsoap.schemas.ws.x2004.x08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseCollectionDocument;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseCollectionType;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseDocument;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseType;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestedSecurityTokenDocument;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestedSecurityTokenType;
import org.xmlsoap.schemas.ws.x2005.x02.trust.TokenTypeDocument;

public final class ClaimsWsTrust12Handler
extends ClaimsUtil {
    @Override
    public XmlObject assembleRSTR(XmlObject assertionType, String partnerId, boolean isSaml2) {
        boolean useRequestSecurityTokenResponseCollection = configStore.getBooleanValue("useRequestSecurityTokenResponseCollection", false);
        XmlObject requestSecurityTokenResponseObjectDocument = null;
        RequestSecurityTokenResponseDocument rstrDoc = RequestSecurityTokenResponseDocument.Factory.newInstance();
        RequestSecurityTokenResponseType rstrType = rstrDoc.addNewRequestSecurityTokenResponse();
        RequestedSecurityTokenDocument requestedSecurityTokenDocument = RequestedSecurityTokenDocument.Factory.newInstance();
        boolean saml2 = false;
        if (assertionType instanceof org.sourceid.saml20.xmlbinding.assertion.AssertionType) {
            saml2 = true;
        }
        if (partnerId.equals("urn:federation:MicrosoftOnline")) {
            this.appendSaml11TokenTypeElementO365((XmlObject)rstrType);
        } else if (saml2) {
            this.appendSamlTokenTypeElement((XmlObject)rstrType, WsTrustTokenType.SAML20.getUri());
        } else {
            this.appendSamlTokenTypeElement((XmlObject)rstrType, WsTrustTokenType.SAML11.getUri());
        }
        this.appendRequestSecurityTokenElement(assertionType, (XmlObject)rstrType, requestedSecurityTokenDocument, saml2);
        this.appendAppliesElement(partnerId, (XmlObject)rstrType);
        requestSecurityTokenResponseObjectDocument = this.handleRootElement(useRequestSecurityTokenResponseCollection, rstrDoc);
        return requestSecurityTokenResponseObjectDocument;
    }

    private XmlObject handleRootElement(boolean useRequestSecurityTokenResponseCollection, RequestSecurityTokenResponseDocument rstrDoc) {
        RequestSecurityTokenResponseCollectionDocument requestSecurityTokenResponseObjectDocument;
        if (useRequestSecurityTokenResponseCollection) {
            requestSecurityTokenResponseObjectDocument = RequestSecurityTokenResponseCollectionDocument.Factory.newInstance();
            RequestSecurityTokenResponseCollectionType requestSecurityTokenResponseCollectionType = requestSecurityTokenResponseObjectDocument.addNewRequestSecurityTokenResponseCollection();
            this.appendElement((XmlObject)requestSecurityTokenResponseCollectionType, (XmlObject)rstrDoc);
        } else {
            requestSecurityTokenResponseObjectDocument = rstrDoc;
        }
        return requestSecurityTokenResponseObjectDocument;
    }

    private void appendSamlTokenTypeElement(XmlObject rstrType, String tokenTypeUri) {
        TokenTypeDocument tokenTypeDoc = TokenTypeDocument.Factory.newInstance();
        tokenTypeDoc.setTokenType(tokenTypeUri);
        this.appendElement(rstrType, (XmlObject)tokenTypeDoc);
    }

    private void appendRequestSecurityTokenElement(XmlObject assertionType, XmlObject rstrType, RequestedSecurityTokenDocument requestedSecurityTokenDocument, boolean isSaml2) {
        RequestedSecurityTokenType rstType = requestedSecurityTokenDocument.addNewRequestedSecurityToken();
        if (isSaml2) {
            AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
            assertionDoc.setAssertion((org.sourceid.saml20.xmlbinding.assertion.AssertionType)assertionType);
            this.appendElement((XmlObject)rstType, (XmlObject)assertionDoc);
        } else {
            org.sourceid.protocol.saml11.xml.AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
            assertionDoc.setAssertion((AssertionType)assertionType);
            this.appendElement((XmlObject)rstType, (XmlObject)assertionDoc);
        }
        this.appendElement(rstrType, (XmlObject)requestedSecurityTokenDocument);
    }

    private void appendSaml11TokenTypeElementO365(XmlObject rstrType) {
        TokenTypeDocument tokenTypeDoc = TokenTypeDocument.Factory.newInstance();
        tokenTypeDoc.setTokenType("urn:oasis:names:tc:SAML:1.0:assertion");
        this.appendElement(rstrType, (XmlObject)tokenTypeDoc);
    }

    EndpointReferenceDocument getEndpointReferenceDocument(String partnerId) {
        EndpointReferenceDocument endPointRefDoc = EndpointReferenceDocument.Factory.newInstance();
        EndpointReferenceType endpointRefType = endPointRefDoc.addNewEndpointReference();
        AttributedURI address = endpointRefType.addNewAddress();
        address.setStringValue(partnerId);
        return endPointRefDoc;
    }

    @Override
    public String getResponseTypeName() {
        return WSTrustVersion.v2005.getResponseType();
    }
}

