/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.WhitelistData;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.domain.validation.RedirectValidationHelper;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.domain.WsFedRespSupport;
import org.sourceid.wsfed.profiles.idp.WsFedRequestHandler;

public class HandleSignoutRequest
implements WsFedRequestHandler,
SloHandler {
    private static final Log log = LogFactory.getLog(HandleSignoutRequest.class);
    protected static final TargetResourceValidationMgr targetResourceValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.wsfed.profiles.idp.HandleSignoutRequest");
    private SLOSupport sloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    public OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx) {
        return new OutMessageContext(Role.SP);
    }

    @Override
    public Map<String, Object> handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        this.clearFrameOptionsHeader(resp);
        boolean currentResult = true;
        String wreply = inMsgCtx.getParam("wreply");
        if (wreply != null && targetResourceValidationMgr.isEnableValidationWreplySLO()) {
            List<UrlWhitelistEntry> whitelist = WsFedRespSupport.getAggregateSpConnRedirectValidationWhitelist();
            RedirectValidationHelper validationHelper = new RedirectValidationHelper();
            WhitelistData wlData = new WhitelistData();
            wlData.setEntries(whitelist);
            try {
                validationHelper.validate(wlData, wreply);
            }
            catch (InvalidRedirectValidationException e) {
                wreply = null;
                currentResult = false;
            }
        }
        String requestStateRef = this.sloSupport.makeRequestStateRef();
        StartSloRequest startSloRequest = new StartSloRequest(requestStateRef, wreply, true, null, null, false);
        startSloRequest.setCurrentResult(currentResult);
        this.sloSupport.sendStartSloRequest(startSloRequest, req, resp);
        return null;
    }

    @Override
    public Map<String, Object> invokeAdapter(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws IOException, GeneralAdapterException {
        return null;
    }

    @Override
    public void finalize(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
    }

    private void clearFrameOptionsHeader(HttpServletResponse resp) {
        if (this.configStore.getBooleanValue("ClearFrameOptionsHeader", true)) {
            resp.setHeader("X-Frame-Options", null);
        }
    }
}

