/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ResumableResponseHandlerBase;
import org.sourceid.websso.profiles.sp.IdpIdCookieSupport;
import org.sourceid.websso.profiles.sp.ProvisioningProcessor;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;
import org.sourceid.wsfed.domain.WsFedParsedRequest;
import org.sourceid.wsfed.profiles.sp.HandleSaml11RSTR;
import org.sourceid.wsfed.profiles.sp.HandleSaml2RSTR;
import org.sourceid.wsfed.profiles.sp.SamlRstrHandler;
import org.sourceid.wsfed.protocol.RstrUtil;

public class HandleRSTR
extends ResumableResponseHandlerBase {
    private static final String KEY_ASSERTION = "assertion";
    static final String REQ_ATTR_KEY_ASSERTION_SIG = "AssertionSigsVerified";
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final SsoRespSupport ssoRespSupport = new SsoRespSupport(this.localMetaData);
    private final ProvisioningProcessor provisioningProcessor = new ProvisioningProcessor();
    private final SpAdapterSupport spAdapterSupport = new SpAdapterSupport();
    private final SLOSupport sloSupport = new SLOSupport();
    private static final String ASSERTION_PARAM_NAME = "assertion";

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(respMsgCtx);
        List<String> virtualEntityIds = VirtualIdentityUtil.getAllowedAudiences(reqMsgCtx, connection);
        Object assertionType = respMsgCtx.getObjParam("assertion");
        if (assertionType == null) {
            assertionType = this.getSAMLAssertions(respMsgCtx);
        }
        WsFedParsedRequest requestObject = new WsFedParsedRequest(assertionType, respMsgCtx.getVirtualServerId(), connection.getEntityId(), virtualEntityIds, (IdpConnection)connection);
        Object newAssertionType = this.validateResponse(requestObject);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("assertion", newAssertionType);
        this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
    }

    private SamlRstrHandler getSamlRequestHandler(Object assertion) {
        if (assertion instanceof AssertionType) {
            return new HandleSaml2RSTR();
        }
        return new HandleSaml11RSTR();
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException, GeneralServiceException {
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(respMsgCtx).toString());
        String partnerEntityId = respMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        SsoContext ssoContext = (SsoContext)params.get("ssoctx");
        SsoContext tempSsoContext = (SsoContext)params.get("tmpssoctx");
        Object assertionType = params.get("assertion");
        IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionMetadata(partnerEntityId);
        SpAuditLogger.setProtocol(idpConnection.getProtocol().toString());
        LicenseManager.checkLicenseForConnection(idpConnection);
        IdpIdCookieSupport.writeIdpIdCookie(resp, partnerEntityId);
        TargetSessionId targetSessionId = this.ssoRespSupport.getTargetSessionIdFromCtx(reqMsgCtx, idpConnection);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)reqMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        if (tempSsoContext == null) {
            String targetUrl = this.ssoRespSupport.getTargetUri(reqMsgCtx, respMsgCtx);
            targetSessionId = this.ssoRespSupport.getTargetSessionId(targetSessionId, targetUrl, idpConnection, virtualServerId);
            params.put("targetsessionid", targetSessionId);
            tempSsoContext = new SsoContext(null, null, null, partnerEntityId, targetUrl);
            params.put("tmpssoctx", tempSsoContext);
        }
        if (targetSessionId == null) {
            targetSessionId = (TargetSessionId)params.get("targetsessionid");
        }
        if (targetSessionId == null) {
            this.ssoRespSupport.finishAndRedirect(req, resp, respMsgCtx.getTargetResource(), partnerEntityId, true);
            return;
        }
        SpAuditLogger.setTargetSessionId(targetSessionId);
        SamlRstrHandler samlHandler = this.getSamlRequestHandler(assertionType);
        params.put("ISRS.DeviceSharingType", this.ssoRespSupport.getDeviceSharingTypeFromCtx(reqMsgCtx));
        if (ssoContext == null) {
            IdpConnHashableAuthnBean idpConnBean = samlHandler.getIdpAuthBean(req, resp, idpConnection.getMaskedAttributeNames(), params, assertionType, StateMgmtFactory.getLocalSessionId(req, resp), partnerEntityId, virtualServerId, idpConnection.getId(), samlHandler.getNameId(assertionType));
            if (idpConnBean.getAssertionAttrs() != null) {
                SpAuditLogger.setAttributes(idpConnBean.getAssertionAttrs().toString());
            }
            if (this.ssoRespSupport.accountLinking(idpConnection, virtualServerId, idpConnBean.getAssertionAttrs(), respMsgCtx, params, targetSessionId, tempSsoContext.getTargetResourceUrl(), req, resp, reqMsgCtx, this)) {
                return;
            }
            if (idpConnection.getUserProvisioning() != null) {
                this.provisioningProcessor.process(req, resp, idpConnection, idpConnBean.getAssertionAttrs());
            }
            SpAuditLogger.setUserName((Map<String, AttributeValue>)idpConnBean.getAssertionAttrs());
            boolean checkRegisterForSso = !samlHandler.hasDoNotCacheAssertion((XmlObject)assertionType);
            try {
                IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, this.ssoRespSupport.getOriginalStateParams(reqMsgCtx, params), idpConnBean, null, checkRegisterForSso, false);
            }
            catch (SessionQuotaException e) {
                throw new GeneralServiceException("Session limit exceeded.");
            }
            String authnCtx = this.ssoRespSupport.getAuthnCtx(idpConnBean);
            AttributeMap contextAttributes = this.ssoRespSupport.makeIdpConnContextAttributes(idpConnBean, req);
            if (this.ssoRespSupport.isResumeOtherHandler(reqMsgCtx, req, resp, idpConnBean, contextAttributes)) {
                return;
            }
            AttributeMap mappedAttributes = this.ssoRespSupport.executeIdpConnMapping(idpConnection, idpConnBean.getAssertionAttrs(), targetSessionId, contextAttributes);
            String targetUrl = tempSsoContext.getTargetResourceUrl();
            Date authnInst = this.ssoRespSupport.getAuthnInst(idpConnBean.getAssertionAttrs());
            ssoContext = new SsoContext(mappedAttributes, null, SsoRespSupport.EMPTY_ASSERTION20_LIST, partnerEntityId, targetUrl, authnCtx, authnInst);
            params.put("ssoctx", ssoContext);
        }
        String resumePath = this.saveState(req, resp, respMsgCtx, reqMsgCtx, params);
        SpHashableAuthnBean authnBean = this.spAdapterSupport.createAuthN(ssoContext, req, resp, targetSessionId, resumePath, reqMsgCtx, respMsgCtx, (IdpConnHashableAuthnBean)params.get("idpConnBean"));
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            if (this.sloSupport.checkRegisterSpAuthnBean(idpConnection, targetSessionId)) {
                samlHandler.registerSessionReceived(authnBean, assertionType, partnerEntityId, virtualServerId);
            }
            this.ssoRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.ssoRespSupport.handleException(e, respMsgCtx, reqMsgCtx, req, resp);
    }

    @Override
    protected void verifySignature(InMessageContext respMsgCtx, HttpServletRequest request) throws InvalidResponseException {
        XmlObject assertionType = this.getSAMLAssertions(respMsgCtx);
        respMsgCtx.setParam("assertion", assertionType);
        SamlRstrHandler samlRequestHandler = this.getSamlRequestHandler(assertionType);
        samlRequestHandler.verifySignature(respMsgCtx, request, assertionType);
    }

    private XmlObject getSAMLAssertions(InMessageContext respMsgCtx) throws InvalidResponseException {
        XmlObject rstrType = RstrUtil.getRequestSecurityTokenResponse(respMsgCtx);
        XmlObject[] assertions = RstrUtil.getAssertions(rstrType);
        if (assertions == null || assertions.length == 0) {
            assertions = RstrUtil.getSaml2Assertions(rstrType);
        }
        if (assertions != null && assertions.length > 0) {
            return assertions[0];
        }
        return null;
    }

    private Object validateResponse(WsFedParsedRequest requestObject) throws InvalidResponseException {
        if (requestObject == null || requestObject.getAssertion() == null) {
            throw new InvalidSsoResponseException("No SAML Assertion is found in RSTR.");
        }
        SamlRstrHandler samlHandler = this.getSamlRequestHandler(requestObject.getAssertion());
        Object spAssertion = samlHandler.validateResponse(requestObject);
        return spAssertion;
    }
}

