/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import com.pingidentity.sdk.DeviceSharingType;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.ConditionsType;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml1x.protocol.AssertionTypeUtil;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.wsfed.domain.WsFedParsedRequest;
import org.sourceid.wsfed.profiles.sp.AssertionValidator;
import org.sourceid.wsfed.profiles.sp.SamlRstrHandler;

public class HandleSaml11RSTR
implements SamlRstrHandler {
    private static final AssertionAssembler assertionAssembler = new AssertionAssembler();

    @Override
    public AttributeMap getAttributeMap(Object assertionType, Set<String> maskedAttributeNames) {
        return assertionAssembler.disassemble((AssertionType)assertionType, maskedAttributeNames);
    }

    @Override
    public IdpConnHashableAuthnBean getIdpAuthBean(HttpServletRequest req, HttpServletResponse resp, Set<String> maskedAttributeNames, Map<String, Object> params, Object assertionType, String localSessionId, String partnerEntityId, String virtualServerId, String connectionId, NameIDType newAssertionId) throws IOException {
        IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)params.get("idpConnBean");
        if (idpConnBean == null) {
            AttributeMap assertionAttributes = assertionAssembler.disassemble((AssertionType)assertionType, maskedAttributeNames);
            IdpConnAuthnSourceKey authnSourceKey = new IdpConnAuthnSourceKey(connectionId);
            DeviceSharingType deviceSharingType = IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(params);
            idpConnBean = new IdpConnHashableAuthnBean(assertionAttributes, localSessionId, (AuthnSourceKey)authnSourceKey, partnerEntityId, localSessionId, virtualServerId, null, null, newAssertionId, deviceSharingType);
            params.put("idpConnBean", idpConnBean);
        }
        return idpConnBean;
    }

    @Override
    public void verifySignature(InMessageContext respMsgCtx, HttpServletRequest request, Object assertionType) throws InvalidSsoResponseException {
        AssertionType assertion = (AssertionType)assertionType;
        SignatureResult sigResult = signatureEngine.verifyAssertionSignature(assertion, assertion.getIssuer());
        SignatureStatus sigStatus = sigResult.getStatus();
        if (sigStatus != SignatureStatus.VALID) {
            StringBuilder sb = new StringBuilder();
            sb.append(sigResult).append(" signature on assertion (ID=").append(assertion.getAssertionID());
            sb.append("). ").append("All assertions must have valid signatures. ");
            sb.append(Util.LINE_BREAK).append(respMsgCtx);
            throw new InvalidSsoResponseException(sb.toString());
        }
        request.setAttribute("AssertionSigsVerified", (Object)true);
    }

    @Override
    public void registerSessionReceived(SpHashableAuthnBean authnBean, Object assertionType, String partnerEntityId, String virtualServerId) {
        SpSessionRegistrySupport.registerSessionReceived(authnBean, (AssertionType)assertionType, partnerEntityId, virtualServerId);
    }

    public AssertionType validateResponse(WsFedParsedRequest wsFedParsedRequest) throws InvalidResponseException {
        AssertionType assertionType = (AssertionType)wsFedParsedRequest.getAssertion();
        AssertionValidator.validateAssertion(assertionType, wsFedParsedRequest.getEntityIds(), wsFedParsedRequest.getPartnerEntityId());
        return assertionType;
    }

    @Override
    public NameIDType getNameId(Object assertionType) {
        return AssertionTypeUtil.getSaml20NameId((AssertionType)assertionType);
    }

    @Override
    public boolean hasDoNotCacheAssertion(XmlObject assertionType) {
        ConditionsType conditions = ((AssertionType)assertionType).getConditions();
        return conditions.sizeOfDoNotCacheConditionArray() > 0;
    }
}

