/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.WhitelistData;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.domain.validation.RedirectValidationHelper;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandlerBase;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.domain.WsFedRespSupport;

public class HandleSignoutCleanupRequest
extends ResumableRequestHandlerBase
implements SloHandler {
    private static final String SIGNOUT_TEMPLATE = "sourceid-wsfed-sp-signout-cleanup-template.html";
    private static final String KEY_PROCESSING_STAGE = "processingStage";
    private static final String KEY_OVERALL_RESULT = "overallResult";
    private static final String KEY_REQUEST_STATE_REF = "requestStateRef";
    private static final String MSG_INCOMPLETE = "Unable to completely sign out of ";
    private static final String MSG_SESSION_NOT_EXIST = "Your user session has expired on ";
    private static final String MSG_EXCEPTION = "Exception occurred during signing out of ";
    private static final String VAR_SUCCESS = "success";
    private static final String VAR_SERVER_NAME = "servername";
    private static final String VAR_MSG = "msg";
    public static final String RESUME_PATH_QUALIFIER = "scr";
    private static TargetResourceValidationMgr targetResourceValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
    private SLOSupport idpSloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.wsfed.profiles.idp.HandleSignoutCleanupRequest");

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext outMsgCtx = new OutMessageContext(Role.IDP);
        outMsgCtx.setBinding("wsfed:prp:http:get");
        outMsgCtx.setEndpoint(inMsgCtx.getParam("wreply"));
        return outMsgCtx;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        this.clearFrameOptionsHeader(resp);
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
        IdpSessionRegistrySupport.setSessionBeansInvalidForSso(Arrays.asList(localSessionId));
        IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
        if (this.hasAnySessions(req, resp)) {
            this.idpSloSupport.checkRevokeUserSession(req, resp);
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put(KEY_PROCESSING_STAGE, (Object)ProcessingStage.LOGGING_OUT_IDP_SIDE);
            params.put(KEY_OVERALL_RESULT, true);
            this.resume(inMsgCtx, req, resp, outMsgCtx, params);
        } else {
            this.processResponse(req, resp, inMsgCtx, SignoutState.SESSION_NOT_EXIST);
        }
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        this.clearFrameOptionsHeader(resp);
        boolean suspend = false;
        while (!suspend) {
            switch (this.getStage(params)) {
                case LOGGING_OUT_IDP_SIDE: {
                    if (this.logoutIdpSide(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, ProcessingStage.DONE);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case WAITING_FOR_IDP_SIDE_RESPONSE: {
                    this.handleIdpSideLogoutResponse(req, resp, params);
                    this.setStage(params, ProcessingStage.DONE);
                    break;
                }
                case DONE: {
                    this.finishLogout(inMsgCtx, req, resp, params);
                    suspend = true;
                }
            }
        }
    }

    protected boolean hasAnySessions(HttpServletRequest req, HttpServletResponse resp) {
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        Map<SpHashableAuthnBean, WebSsoSession> beansAndSessions = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(localSessionId);
        return !beansAndSessions.isEmpty() || IdpSessionRegistrySupport.hasSessions(req, resp);
    }

    protected boolean logoutIdpSide(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws IOException {
        if (!this.hasAnySessions(req, resp)) {
            return true;
        }
        String requestStateRef = this.idpSloSupport.makeRequestStateRef();
        params.put(KEY_REQUEST_STATE_REF, requestStateRef);
        this.setStage(params, ProcessingStage.WAITING_FOR_IDP_SIDE_RESPONSE);
        String resumeUrl = this.saveState(req, resp, inMsgCtx, outMsgCtx, params);
        this.idpSloSupport.sendStartSloRequest(new StartSloRequest(requestStateRef, resumeUrl, false), req, resp);
        return false;
    }

    protected void handleIdpSideLogoutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws RequestProcessingException {
        String requestStateRef = (String)params.get(KEY_REQUEST_STATE_REF);
        StartSloResponse response = this.idpSloSupport.getStartSloResponse(requestStateRef, req, resp);
        if (response == null) {
            throw new RequestProcessingException("Expected StartSloResponse but none was found");
        }
        if (!response.getOverallResult()) {
            params.put(KEY_OVERALL_RESULT, false);
        }
    }

    protected void finishLogout(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (params.get(KEY_OVERALL_RESULT) != null && ((Boolean)params.get(KEY_OVERALL_RESULT)).booleanValue()) {
            this.processResponse(req, resp, inMsgCtx, SignoutState.SUCCESS);
        } else {
            this.processResponse(req, resp, inMsgCtx, SignoutState.INCOMPLETE);
        }
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.processResponse(req, resp, inMsgCtx, SignoutState.EXCEPTION);
        }
        catch (IOException ex) {
            this.log.error((Object)("IOException occurred during handling exception " + e.getMessage()));
        }
    }

    private ProcessingStage getStage(Map<String, Object> params) {
        return (ProcessingStage)((Object)params.get(KEY_PROCESSING_STAGE));
    }

    private void setStage(Map<String, Object> params, ProcessingStage stage) {
        params.put(KEY_PROCESSING_STAGE, (Object)stage);
    }

    private void processResponse(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, SignoutState state) throws IOException {
        String wreply = inMsgCtx.getParam("wreply");
        if (wreply != null && targetResourceValidationMgr.isEnableValidationWreplySLO()) {
            List<UrlWhitelistEntry> whitelist = WsFedRespSupport.getAggregateIdpConnRedirectValidationWhitelist();
            RedirectValidationHelper validationHelper = new RedirectValidationHelper();
            WhitelistData wlData = new WhitelistData();
            wlData.setEntries(whitelist);
            try {
                validationHelper.validate(wlData, wreply);
            }
            catch (InvalidRedirectValidationException e) {
                wreply = null;
                state = SignoutState.EXCEPTION;
            }
        }
        if (!StringUtils.isBlank((String)wreply)) {
            resp.sendRedirect(wreply);
        } else {
            this.sendResponse(req, resp, state);
        }
    }

    private void sendResponse(HttpServletRequest req, HttpServletResponse resp, SignoutState state) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        Object msg = "";
        Boolean success = Boolean.FALSE;
        if (state == SignoutState.SUCCESS) {
            objMap.put(VAR_SERVER_NAME, req.getServerName());
            success = Boolean.TRUE;
        } else if (state == SignoutState.INCOMPLETE) {
            msg = (String)msg + MSG_INCOMPLETE + req.getServerName();
            objMap.put(VAR_MSG, msg);
        } else if (state == SignoutState.SESSION_NOT_EXIST) {
            msg = (String)msg + MSG_SESSION_NOT_EXIST + req.getServerName();
            objMap.put(VAR_MSG, msg);
        } else if (state == SignoutState.EXCEPTION) {
            msg = (String)msg + MSG_EXCEPTION + req.getServerName();
            objMap.put(VAR_MSG, msg);
        }
        objMap.put(VAR_SUCCESS, success);
        try {
            this.renderer.render(req, resp, SIGNOUT_TEMPLATE, objMap);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Unable to send out signout cleanup message.", ex);
        }
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        return state.getParameters().containsKey(KEY_PROCESSING_STAGE);
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return RESUME_PATH_QUALIFIER;
    }

    private void clearFrameOptionsHeader(HttpServletResponse resp) {
        if (this.configStore.getBooleanValue("ClearFrameOptionsHeader", true)) {
            resp.setHeader("X-Frame-Options", null);
        }
    }

    static enum ProcessingStage {
        LOGGING_OUT_IDP_SIDE,
        WAITING_FOR_IDP_SIDE_RESPONSE,
        DONE;

    }

    static enum SignoutState {
        SUCCESS,
        SESSION_NOT_EXIST,
        INCOMPLETE,
        EXCEPTION;

    }
}

