/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectBuilder;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.SoapFaultAware;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.protocol.soap12.xml.Body;
import org.sourceid.protocol.soap12.xml.Envelope;
import org.sourceid.protocol.soap12.xml.EnvelopeDocument;
import org.sourceid.protocol.soap12.xml.Fault;
import org.sourceid.protocol.soap12.xml.FaultDocument;
import org.sourceid.protocol.soap12.xml.Faultcode;
import org.sourceid.protocol.soap12.xml.Faultreason;
import org.sourceid.protocol.soap12.xml.Header;
import org.sourceid.protocol.soap12.xml.Reasontext;
import org.sourceid.protocol.soap12.xml.Subcode;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.wstrust.bindings.WSTrustBinding;
import org.sourceid.wstrust.bindings.WSTrustSoapBaseBinding;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.mapper.XmlLocalName;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;
import org.sourceid.wstrust.wsse.WsseProcessingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSTrustSoap12Binding
extends WSTrustSoapBaseBinding {
    private static final ConfigStore CONFIG = ConfigStoreFarm.getConfig("org.sourceid.wstrust.bindings.WSTrustSoap12Binding.PartnerEntityIdAndFaultInfo");
    private static final String KEY_PARTNER_ENTITYID = "PartnerEntityId";
    private static final String KEY_INVALIDTOKEN_FAULTCODE = "InvalidTokenResponseFaultCode";
    private static final String KEY_INVALIDTOKEN_FAULTSTRING = "InvalidTokenResponseFaultString";
    public static final List<String> PARTNER_ENTITY_ID_LIST;
    private static final String INVALIDTOKEN_RESPONSE_FAULTCODE;
    private static final String INVALIDTOKEN_RESPONSE_FAULTSTRING;
    private static Log logger;

    @Override
    public String getUri() {
        return WSTrustBinding.SOAP12.uri();
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        Node actionNode;
        EnvelopeDocument soapResponse = EnvelopeDocument.Factory.newInstance();
        Body responseBody = null;
        boolean customizeSoapFault = false;
        String messageId = null;
        Fault fault = Fault.Factory.newInstance();
        Faultcode code = fault.addNewCode();
        if (e instanceof WsseProcessingException || e instanceof WSTrustException) {
            String partnerEntityId = null;
            boolean isWsseProcessingException = false;
            boolean isWSTrustException = false;
            WsseProcessingException wsseProcessingException = null;
            WSTrustException wsTrustException = null;
            if (e instanceof WsseProcessingException) {
                wsseProcessingException = (WsseProcessingException)e;
                partnerEntityId = wsseProcessingException.getPartnerEntityId();
                messageId = wsseProcessingException.getRelatesTo();
                isWsseProcessingException = true;
            } else if (e instanceof WSTrustException) {
                wsTrustException = (WSTrustException)e;
                partnerEntityId = wsTrustException.getPartnerEntityId();
                messageId = wsTrustException.getRelatesTo();
                isWSTrustException = true;
            }
            if (PARTNER_ENTITY_ID_LIST != null && PARTNER_ENTITY_ID_LIST.contains(partnerEntityId)) {
                customizeSoapFault = true;
                if (isWsseProcessingException) {
                    wsseProcessingException.setFaultCode(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", INVALIDTOKEN_RESPONSE_FAULTCODE));
                    wsseProcessingException.setFaultReason(INVALIDTOKEN_RESPONSE_FAULTSTRING);
                } else if (isWSTrustException) {
                    wsTrustException.setFaultCode(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", INVALIDTOKEN_RESPONSE_FAULTCODE));
                    wsTrustException.setFaultReason(INVALIDTOKEN_RESPONSE_FAULTSTRING);
                }
            }
        }
        if (customizeSoapFault) {
            responseBody = soapResponse.addNewEnvelope().addNewBody();
            if (e instanceof SoapFaultAware && ((SoapFaultAware)((Object)e)).getWsaVersion() != null) {
                SoapFaultAware soapFault = (SoapFaultAware)((Object)e);
                WsaVersion wsaVersion = soapFault.getWsaVersion();
                if (soapResponse.getDomNode().getNodeType() == 9) {
                    Document doc = (Document)soapResponse.getDomNode();
                    Element elem = (Element)doc.getElementsByTagName("Envelope").item(0);
                    elem.setAttribute("xmlns:a", wsaVersion.getUri());
                }
                Header header = soapResponse.getEnvelope().addNewHeader();
                XmlObject actionXmlObject = this.getActionXmlObject(wsaVersion, "http://www.w3.org/2003/05/soap-envelope");
                actionNode = actionXmlObject.newDomNode();
                if (actionNode.getNodeType() == 9) {
                    actionNode = ((Document)actionNode).getDocumentElement();
                }
                actionNode = header.getDomNode().getOwnerDocument().importNode(actionNode, true);
                header.getDomNode().appendChild(actionNode);
                if (messageId != null && !messageId.isEmpty()) {
                    header.getDomNode().appendChild(this.generateRelatesToXmlObject(messageId, wsaVersion, header));
                }
            }
            fault = this.generateFault(e);
        } else {
            QName codeValue;
            Envelope envelope = soapResponse.addNewEnvelope();
            if (e instanceof SoapFaultAware && ((SoapFaultAware)((Object)e)).getWsaVersion() != null) {
                SoapFaultAware soapFault = (SoapFaultAware)((Object)e);
                WsaVersion wsaVersion = soapFault.getWsaVersion();
                Header header = envelope.addNewHeader();
                actionNode = this.generateActionNode(wsaVersion, header);
                header.getDomNode().appendChild(actionNode);
                if (soapFault.getRelatesTo() != null && !soapFault.getRelatesTo().isEmpty()) {
                    Node relatesToNode = this.generateRelatesToXmlObject(soapFault.getRelatesTo(), wsaVersion, header);
                    header.getDomNode().appendChild(relatesToNode);
                }
            }
            responseBody = envelope.addNewBody();
            if ((e = this.findBetterException(e)) instanceof SoapFaultAware && ((SoapFaultAware)((Object)e)).getFaultCode() != null) {
                codeValue = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender");
                Subcode subCode = code.addNewSubcode();
                subCode.setValue(((SoapFaultAware)((Object)e)).getFaultCode());
                code.setSubcode(subCode);
            } else {
                codeValue = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
            }
            code.setValue(codeValue);
            fault.setCode(code);
            String reasonString = e instanceof SoapFaultAware && ((SoapFaultAware)((Object)e)).getFaultReason() != null ? ((SoapFaultAware)((Object)e)).getFaultReason() : e.getMessage();
            Faultreason reason = fault.addNewReason();
            Reasontext reasonText = reason.addNewText();
            reasonText.setStringValue(reasonString);
            XmlBeansUtil.setAttributeValue((XmlObject)reasonText, "en", "http://www.w3.org/XML/1998/namespace", "lang");
            fault.setReason(reason);
        }
        FaultDocument faultDoc = FaultDocument.Factory.newInstance();
        faultDoc.setFault(fault);
        responseBody.set((XmlObject)faultDoc);
        resp.setContentType(this.getContentType());
        resp.setStatus(500);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Soap response: " + soapResponse.toString()));
        }
        XmlBeansUtil.save((XmlObject)soapResponse, resp.getWriter());
        resp.flushBuffer();
    }

    private Fault generateFault(Exception e) {
        String faultReasonString;
        Fault fault = Fault.Factory.newInstance();
        Faultcode code = fault.addNewCode();
        Faultreason faultReason = fault.addNewReason();
        Reasontext faultReasonText = faultReason.addNewText();
        if ((e = this.findBetterException(e)) instanceof SoapFaultAware) {
            XmlObject sender = XmlObjectBuilder.element(new QName("http://www.w3.org/2003/05/soap-envelope", "Value", "s"), "s:Sender");
            code.set(sender);
            if (((SoapFaultAware)((Object)e)).getFaultCode() != null) {
                Subcode subCode = this.generateSubcode(e, code);
                code.setSubcode(subCode);
                faultReasonString = ((SoapFaultAware)((Object)e)).getFaultReason();
            } else {
                faultReasonString = e.getMessage();
            }
        } else {
            QName codeValue = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
            code.setValue(codeValue);
            faultReasonString = e.getMessage();
        }
        fault.setCode(code);
        faultReasonText.setStringValue(faultReasonString);
        XmlBeansUtil.setAttributeValue((XmlObject)faultReasonText, "en", "http://www.w3.org/XML/1998/namespace", "lang");
        fault.setReason(faultReason);
        return fault;
    }

    private Subcode generateSubcode(Exception e, Faultcode code) {
        Subcode subCode = code.addNewSubcode();
        XmlObjectBuilder.Attribute[] valueAttrs = new XmlObjectBuilder.Attribute[]{XmlObjectBuilder.attr(new QName("http://www.w3.org/2003/05/soap-envelope", "a", "xmlns"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")};
        String faultCodeString = ((SoapFaultAware)((Object)e)).getFaultCode().getLocalPart();
        XmlObject valueXmlObject = XmlObjectBuilder.element(new QName("http://www.w3.org/2003/05/soap-envelope", "Value", "s"), valueAttrs, "a:" + faultCodeString);
        subCode.set(valueXmlObject);
        return subCode;
    }

    private Node generateRelatesToXmlObject(String messageId, WsaVersion wsaVersion, Header header) {
        XmlObject relatesToXmlObject = XmlObjectBuilder.element(new QName(wsaVersion.getUri(), XmlLocalName.RELATES_TO.getLocalName(), "a"), messageId);
        Node relatesToNode = relatesToXmlObject.newDomNode();
        if (relatesToNode.getNodeType() == 9) {
            relatesToNode = ((Document)relatesToNode).getDocumentElement();
        }
        relatesToNode = header.getDomNode().getOwnerDocument().importNode(relatesToNode, true);
        return relatesToNode;
    }

    private Node generateActionNode(WsaVersion wsaVersion, Header header) {
        XmlObject actionXmlObject = this.getActionXmlObject(wsaVersion, "http://www.w3.org/2003/05/soap-envelope");
        Node actionNode = actionXmlObject.newDomNode();
        if (actionNode.getNodeType() == 9) {
            actionNode = ((Document)actionNode).getDocumentElement();
        }
        actionNode = header.getDomNode().getOwnerDocument().importNode(actionNode, true);
        return actionNode;
    }

    private XmlObject getActionXmlObject(WsaVersion wsaVersion, String soapNameSpaceURI) {
        XmlObjectBuilder.Attribute[] attrs = new XmlObjectBuilder.Attribute[]{XmlObjectBuilder.attr(new QName(soapNameSpaceURI, "mustUnderstand", "s"), "1")};
        XmlObject actionXmlObject = XmlObjectBuilder.element(new QName(wsaVersion.getUri(), XmlLocalName.ACTION.getLocalName(), "a"), attrs, wsaVersion.getSoapFaultUri());
        return actionXmlObject;
    }

    @Override
    protected String getContentType() {
        return "application/soap+xml; charset=utf-8";
    }

    static {
        logger = LogFactory.getLog(WSTrustSoap12Binding.class);
        List<String> partnerEntityIdList = null;
        String invalidTokenResponseFaultCode = null;
        String invalidTokenResponseFaultString = null;
        try {
            partnerEntityIdList = CONFIG.getListValue(KEY_PARTNER_ENTITYID);
            invalidTokenResponseFaultCode = CONFIG.getStringValue(KEY_INVALIDTOKEN_FAULTCODE);
            invalidTokenResponseFaultString = CONFIG.getStringValue(KEY_INVALIDTOKEN_FAULTSTRING);
        }
        catch (NoSuchValueException e) {
            logger.info((Object)("Error reading " + CONFIG + ".xml"));
        }
        PARTNER_ENTITY_ID_LIST = partnerEntityIdList;
        INVALIDTOKEN_RESPONSE_FAULTCODE = invalidTokenResponseFaultCode;
        INVALIDTOKEN_RESPONSE_FAULTSTRING = invalidTokenResponseFaultString;
    }
}

