/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapFaultAware;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.bindings.WSTrustSoapGenerator;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;
import org.sourceid.wstrust.transport.HttpAuthnChallenge;
import org.sourceid.wstrust.wsse.TimestampValidator;
import org.sourceid.wstrust.wsse.WsseProcessor;

public abstract class WSTrustSoapBaseBinding
implements Binding {
    protected final WsseProcessor wsseProcessor = new WsseProcessor();
    protected final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();

    WSTrustSoapBaseBinding() {
        ConfigStore configStore = ConfigStoreFarm.getConfig("wstrust-global-settings");
        int messageValidityInMinutes = configStore.getIntValue("MessageValidityInMinutes", 5);
        TimestampValidator timestampValidator = new TimestampValidator();
        timestampValidator.setEnforceMaxFuture(true);
        timestampValidator.setMaxFutureValidityInMinutes(configStore.getIntValue("MaxFutureValidityInMinutes", 720));
        this.wsseProcessor.setTimestampValidator(timestampValidator);
        this.wsseProcessor.setMessageValidityInMinutes(messageValidityInMinutes);
    }

    @Override
    public WsTrustInMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException {
        WsTrustInMessageContext inMsgCtx = new WsTrustInMessageContext(partnerRole);
        inMsgCtx.setResolver(new IdBasedResolver());
        inMsgCtx.setBinding(this.getUri());
        inMsgCtx.setIsRequest(true);
        SoapServerSupport soapSupport = SoapServerSupport.getSupport(request);
        try {
            SpConnection sp;
            inMsgCtx.getResolver().register(soapSupport.getBody());
            XmlObject envelope = soapSupport.getEnvelope();
            inMsgCtx.setXmlObject(envelope);
            XmlBeansUtil.validate(envelope);
            XmlObject firstElementInBody = soapSupport.getFirstElementInBody();
            SoapHeaders soapHeaders = WSTrustXmlMapper.mapSoapHeaders(envelope, inMsgCtx.getResolver());
            this.findNamespaceVersions(inMsgCtx);
            inMsgCtx.setSoapHeaders(soapHeaders);
            String wst = XmlBeansUtil.getNamespaceUri(firstElementInBody);
            inMsgCtx.setActualWsTrustNamespace(wst);
            inMsgCtx.setWsTrustVersion(WSTrustVersion.fromDocumentNamespaceUri(wst));
            inMsgCtx.setRstXmlObject(firstElementInBody);
            WSTrustProtocolManager protocol = GlobalRegistry.getService(inMsgCtx.getWsTrustVersion().getProtocolManagerServiceId(), WSTrustProtocolManager.class);
            RequestSecurityToken rst = protocol.receive(inMsgCtx);
            inMsgCtx.setRst(rst);
            if (rst.getAppliesTo() != null && partnerRole == Role.SP && (sp = this.metadataDirectory.getSpConnectionByAppliesTo(rst.getAppliesTo())) != null) {
                String virtualServerId = VirtualIdentityUtil.resolve(sp, request).getVirtualEntityId(DomainMode.RUNTIME);
                inMsgCtx.setVirtualServerId(virtualServerId);
            }
            Enumeration authnHeaders = request.getHeaders("Authorization");
            while (authnHeaders.hasMoreElements()) {
                String authnValue = (String)authnHeaders.nextElement();
                SecurityToken token = HttpAuthnChallenge.createSecurityToken(authnValue);
                if (token == null) continue;
                inMsgCtx.addHttpHeaderSecurityToken(token);
            }
            String tokenProcessorId = request.getParameter("TokenProcessorId");
            inMsgCtx.setRequestTokenProcessorId(tokenProcessorId);
            String tokenGeneratorId = request.getParameter("TokenGeneratorId");
            inMsgCtx.setRequestTokenGeneratorId(tokenGeneratorId);
            inMsgCtx.setRequestIpAddress(request.getRemoteAddr());
            this.setSTSAuditLoggingInfo(inMsgCtx);
            this.wsseProcessor.process(inMsgCtx);
        }
        catch (InvalidRequestException e) {
            throw new BindingException(e);
        }
        catch (InvalidXmlException e) {
            throw new BindingException(e.getMessage(), e);
        }
        return inMsgCtx;
    }

    private void setSTSAuditLoggingInfo(WsTrustInMessageContext inMsgCtx) {
        RequestSecurityToken rst = inMsgCtx.getRst();
        STSAuditLogger.init();
        if (rst.getRequestType() != null) {
            switch (rst.getRequestType()) {
                case ISSUE: {
                    STSAuditLogger.setInMsgType("TokenIssue");
                    break;
                }
                case VALIDATE: {
                    STSAuditLogger.setInMsgType("TokenValidate");
                    break;
                }
            }
        }
        STSAuditLogger.setInMsgCtx(inMsgCtx);
    }

    private void findNamespaceVersions(WsTrustInMessageContext inMsgctx) {
        XmlObjectWalker walker = new XmlObjectWalker(inMsgctx.getXmlObject());
        walker.addCallback(this.namespaceInspectorCallback(inMsgctx));
        walker.walkEveryNode();
    }

    private XmlObjectWalker.VisitCallback namespaceInspectorCallback(final WsTrustInMessageContext ctx) {
        return new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xmlObject, QName qName) {
                if (ctx.getWsaVersion() == null) {
                    ctx.setWsaVersion(WsaVersion.fromUri(qName.getNamespaceURI()));
                }
            }
        };
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        WsTrustOutMessageContext ctx = (WsTrustOutMessageContext)msgCtx;
        WSTrustVersion wsTrustVersion = ctx.getWsTrustVersion();
        WSTrustSoapGenerator generator = new WSTrustSoapGenerator(this.getUri(), wsTrustVersion, ctx.getWsaVersion(), this.wsseProcessor);
        XmlObject soapEnvelope = generator.generateEnvelope(ctx.getHeaders(), ctx.getXmlObject());
        ctx.setXmlObject(soapEnvelope);
        response.setContentType(this.getContentType());
        XmlBeansUtil.save(soapEnvelope, response.getWriter());
    }

    protected abstract String getContentType();

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) {
        throw new UnsupportedOperationException("WS-Trust Requests aren't sent from the server");
    }

    @Override
    public boolean isBackChannel() {
        return true;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    public WsseProcessor getWsseProcessor() {
        return this.wsseProcessor;
    }

    Exception findBetterException(Exception e) {
        Throwable e1 = e;
        while (!(e1 instanceof SoapFaultAware)) {
            if (e1.getCause() == null || e1 == e1.getCause()) {
                return e;
            }
            e1 = e1.getCause();
        }
        return e1;
    }
}

