/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import com.pingidentity.common.util.xml.XmlObjectBuilder;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.Timestamp;
import org.sourceid.wstrust.model.mapper.XmlLocalName;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;
import org.sourceid.wstrust.wsse.WsseProcessor;

class WSTrustSoapGenerator {
    private final WSTrustVersion wsTrustVersion;
    private final String soapNS;
    private final WsaVersion wsaVersion;
    private final WsseProcessor wsseProcessor;

    public WSTrustSoapGenerator(String soapNS, WSTrustVersion wsTrustVersion, WsaVersion wsaVersion, WsseProcessor wsseProcessor) {
        this.soapNS = soapNS;
        this.wsTrustVersion = wsTrustVersion;
        this.wsaVersion = wsaVersion;
        this.wsseProcessor = wsseProcessor;
    }

    public XmlObject generateEnvelope(SoapHeaders headers, XmlObject rstr) {
        Timestamp timestamp = this.wsseProcessor.generateTimestamp();
        String wsa = this.wsaVersion != null ? this.wsaVersion.getUri() : this.wsTrustVersion.getCorrespondingWSANamespace().getUri();
        return XmlObjectBuilder.element(new QName(this.soapNS, "Envelope"), XmlObjectBuilder.element(new QName(this.soapNS, "Header"), XmlObjectBuilder.element(new QName(wsa, XmlLocalName.TO.getLocalName()), headers.getTo()), XmlObjectBuilder.element(new QName(wsa, XmlLocalName.ACTION.getLocalName()), headers.getAction()), XmlObjectBuilder.element(new QName(wsa, XmlLocalName.RELATES_TO.getLocalName()), headers.getRelatesTo()), XmlObjectBuilder.element(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr(new QName(this.soapNS, "mustUnderstand"), "1")), new XmlObject[]{timestamp.build()})), XmlObjectBuilder.element(new QName(this.soapNS, "Body"), rstr));
    }
}

