/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;

public class WsTrustBasicAuthFilter
extends AbstractHttpFilter {
    private final WsTrustBasicAuthManager authnManager = GlobalRegistry.getService(WsTrustBasicAuthManager.class);
    private final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getSimpleName());

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        block8: {
            this.log.debug((Object)"+ doFilter");
            if (!this.authnManager.isAuthenticationEnabled()) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String authnHeaderValue = BasicAuthHelp.getAuthTokenFromHeaders(request);
            if (authnHeaderValue != null) {
                try {
                    BasicAuthValue values = BasicAuthHelp.getValues(authnHeaderValue);
                    String userKey = AccountLockingService.getUserKey(request.getRemoteAddr(), values.getUsername());
                    if (this.accountLockingService.isLocked(userKey)) {
                        this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false"));
                        BasicAuthHelp.sendChallenge(response, "HTTP Basic Authentication Failed - Account Locked");
                        return;
                    }
                    boolean authenticated = this.authnManager.authenticate(values.getUsername(), values.getPassword());
                    if (authenticated) {
                        this.accountLockingService.clearFailedLogins(userKey);
                        this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=true"));
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        break block8;
                    }
                    this.accountLockingService.logFailedLogin(userKey);
                    this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false"));
                    if (this.accountLockingService.isLocked(userKey)) {
                        BasicAuthHelp.sendChallenge(response, "HTTP Basic Authentication Failed - Account Locked");
                        break block8;
                    }
                    BasicAuthHelp.sendChallenge(response, "HTTP Basic Authentication Failed - Bad username/password");
                }
                catch (LoginException e) {
                    this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false, service-active=true, msg=" + e.getMessage()));
                    BasicAuthHelp.sendChallenge(response);
                }
            } else {
                this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false"));
                BasicAuthHelp.sendChallenge(response);
            }
        }
    }
}

