/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;

public class WsTrustClientCertAuthFilter
extends AbstractHttpFilter {
    private static final String AUTHN_REQUIRED = "Client Certificate Authentication Required";
    private static final String AUTHN_FAILED_SUBJECT = "Client Certificate Authentication Failed - Subject DN is not recognized";
    private static final String AUTHN_FAILED_ISSUER = "Client Certificate Authentication Failed - Certificate chain is not recognized";
    private final WsTrustClientCertAuthManager authnManager = GlobalRegistry.getService(WsTrustClientCertAuthManager.class);

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.log.debug((Object)"+ doFilter");
        if (!this.authnManager.isAuthenticationEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        X509Certificate[] clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (clientCerts != null && clientCerts.length > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Client certificates from request attribute javax.servlet.request.X509Certificate:");
                for (int i = 0; i < clientCerts.length; ++i) {
                    this.log.debug((Object)("  [" + i + "] = " + clientCerts[i]));
                }
            }
            if (this.authnManager.isIssuerAcceptable(clientCerts)) {
                if (this.authnManager.isSubjectDnAcceptable(clientCerts)) {
                    this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=true"));
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    this.log.debug((Object)"authnManager.isSubjectDnAcceptable() returned false");
                    this.sendAuthError(request, response, AUTHN_FAILED_SUBJECT);
                }
            } else {
                this.log.debug((Object)"authnManager.isIssuerAcceptable() returned false");
                this.sendAuthError(request, response, AUTHN_FAILED_ISSUER);
            }
        } else {
            this.log.debug((Object)"No clientCerts found.");
            this.sendAuthError(request, response, AUTHN_REQUIRED);
        }
    }

    private void sendAuthError(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        this.log.info((Object)("WST request: uri=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", authentication-success=false"));
        response.sendError(401, message);
    }
}

