/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.crypto;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdBasedResolver
extends ResourceResolverSpi {
    private Map<String, XmlObject> idToXmlObj = new HashMap<String, XmlObject>();

    public void register(XmlObject obj) {
        String id = XmlBeansUtil.getAttributeValue(obj, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id != null) {
            this.idToXmlObj.put(id, obj);
        }
    }

    public Set<String> getRegistredIds() {
        return this.idToXmlObj.keySet();
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String key = this.normalize(uri);
        XmlObject xmlObj = this.idToXmlObj.get(key);
        Element domElement = XmlSignatureUtil.toDomElement(xmlObj);
        return new XMLSignatureInput((Node)domElement);
    }

    private String normalize(Attr uri) {
        String value = uri.getValue();
        return value.startsWith("#") ? value.substring(1) : value;
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        return this.idToXmlObj.containsKey(this.normalize(uri));
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        return this.engineResolve(context.attr, context.baseUri);
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return this.engineCanResolve(context.attr, context.baseUri);
    }
}

