/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.generator.saml;

import com.pingidentity.access.KeyAccessor;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ognl.ExpressionCalculator;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.xml.XmlHelper;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.DsigKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.EncryptionCertificateFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.generator.saml.SamlTokenGeneratorConfigurationValidator;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;

public abstract class AbstractSamlGenerator
implements TokenGenerator {
    protected static final RequiredFieldValidator REQUIRED_VALIDATOR = new RequiredFieldValidator();
    protected static final IntegerValidator INTEGER_VALIDATOR = new IntegerValidator(0, 65535);
    private MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected int assertionValidityBeforeMinutes;
    protected int assertionValidityAfterMinutes;
    protected String issuer = this.localMetaData.getEntityId();
    protected String audience;
    protected String confirmationMethod;
    protected X500PrivateCredential signingCertificate;
    protected X509Certificate encryptionCertificate;
    protected boolean includeCertInKeyInfo = false;
    protected boolean includeRawKeyInKeyValue = false;
    private String signingAlgorithm = null;
    private String customisationExpression = null;
    protected PluginDescriptor descriptor;
    GuiConfigDescriptor gui = new GuiConfigDescriptor(this.getGeneratorName());
    public static final String FIELD_AUDIENCE = "Audience";
    public static final String FIELD_ISSUER = "Issuer";
    public static final String FIELD_MIN_BEFORE = "Minutes Before";
    public static final String FIELD_MIN_AFTER = "Minutes After";
    public static final String FIELD_SIGNING_CERT = "Signing Certificate";
    public static final String FIELD_SIGNING_ALGO = "Signing Algorithm";
    public static final String FIELD_KEYINFO = "Include Certificate in KeyInfo";
    public static final String FIELD_KEYVALUE = "Include Raw Key in KeyValue";
    public static final String FIELD_ENCRYPTION_CERT = "Encryption Certificate";
    public static final String FIELD_CONFIRMATION_METHOD = "Confirmation Method";
    public static final String FIELD_CUSTOMIZATION_EXPRESSION = "Message Customization Expression";
    protected static final String DESCRIPTION_FORMAT = "SAML %s Token Generator";
    public static final String SHA1 = "SHA1";

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public X509Certificate getSigningCert() {
        return this.signingCertificate.getCertificate();
    }

    public void setSigningCertificate(X500PrivateCredential signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getCustomisationExpression() {
        return this.customisationExpression;
    }

    public void setCustomisationExpression(String customisationExpression) {
        this.customisationExpression = customisationExpression;
    }

    public AbstractSamlGenerator() {
        SignatureAlgorithms signatureAlgsUtils = SignatureAlgorithms.getInstance();
        TextFieldDescriptor assertionValidityBeforeMinutes = new TextFieldDescriptor(FIELD_MIN_BEFORE, "The earliest time for which the generated SAML token will be valid.");
        assertionValidityBeforeMinutes.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        assertionValidityBeforeMinutes.addValidator((FieldValidator)INTEGER_VALIDATOR);
        TextFieldDescriptor assertionValidityAfterMinutes = new TextFieldDescriptor(FIELD_MIN_AFTER, "The latest time for which the generated SAML token will be valid.");
        assertionValidityAfterMinutes.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        assertionValidityAfterMinutes.addValidator((FieldValidator)INTEGER_VALIDATOR);
        TextFieldDescriptor issuer = new TextFieldDescriptor(FIELD_ISSUER, "A unique identifier for the published SAML authority generating the token.");
        issuer.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        issuer.addValidator((FieldValidator)new EntityIdValidator());
        DsigKeypairFieldDescriptor keypair = new DsigKeypairFieldDescriptor(FIELD_SIGNING_CERT, "Select the signing certificate that will be used to sign the generated assertion.");
        keypair.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        SelectFieldDescriptor signingAlgorithmField = new SelectFieldDescriptor(FIELD_SIGNING_ALGO, "Select the signing algorithm and the key size for the signing certificate.", this.getSupportedSigningAlgs(signatureAlgsUtils));
        signingAlgorithmField.setDefaultForLegacyConfig(SHA1);
        signingAlgorithmField.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        CheckBoxFieldDescriptor keyinfo = new CheckBoxFieldDescriptor(FIELD_KEYINFO, "Include the certificate in the signature <KeyInfo> element.");
        keyinfo.setDefaultValue(this.includeCertInKeyInfo);
        CheckBoxFieldDescriptor keyValue = new CheckBoxFieldDescriptor(FIELD_KEYVALUE, "Include the raw key in the signature <KeyValue> element.");
        keyValue.setDefaultValue(this.includeRawKeyInKeyValue);
        EncryptionCertificateFieldDescriptor encryptionCert = new EncryptionCertificateFieldDescriptor(FIELD_ENCRYPTION_CERT, "The encryption certificate to be used for the holder-of-key Confirmation Method.", this.getCertificateFeatureName());
        TextFieldDescriptor audience = new TextFieldDescriptor(FIELD_AUDIENCE, "A URI reference that identifies the intended audience of the generated assertion.");
        audience.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        audience.addValidator((FieldValidator)new EntityIdValidator());
        TextAreaFieldDescriptor expression = new TextAreaFieldDescriptor(FIELD_CUSTOMIZATION_EXPRESSION, "An OGNL expression to customize the assertion. Use the available #AssertionType variable for customisation.", 10, 48);
        expression.setExpression(true);
        String[] confirmationMethods = new String[this.getConfirmationMethods().size()];
        for (int i = 0; i < this.getConfirmationMethods().size(); ++i) {
            confirmationMethods[i] = this.getConfirmationMethods().get(i);
        }
        SelectFieldDescriptor confirmationMethodSelectField = new SelectFieldDescriptor(FIELD_CONFIRMATION_METHOD, "The method for verifying the SAML subject in the token.", confirmationMethods);
        confirmationMethodSelectField.setDefaultValue(this.getConfirmationMethods().get(0));
        this.gui.addField((FieldDescriptor)assertionValidityBeforeMinutes);
        this.gui.addField((FieldDescriptor)assertionValidityAfterMinutes);
        this.gui.addField((FieldDescriptor)issuer);
        this.gui.addField((FieldDescriptor)keypair);
        this.gui.addField((FieldDescriptor)signingAlgorithmField);
        this.gui.addField((FieldDescriptor)keyinfo);
        this.gui.addField((FieldDescriptor)keyValue);
        this.gui.addField((FieldDescriptor)audience);
        this.gui.addField((FieldDescriptor)confirmationMethodSelectField);
        this.gui.addField((FieldDescriptor)encryptionCert);
        this.gui.addAdvancedField((FieldDescriptor)expression);
        this.gui.addValidator((ConfigurationValidator)new SamlTokenGeneratorConfigurationValidator());
        Set<String> contract = Collections.singleton(AssertionMapKeys.getNameIdValueKey());
        this.descriptor = new TokenPluginDescriptor(this.getGeneratorName(), (Plugin)this, this.gui, this.getTokenType(), contract, this.getVersion());
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        Field fieldEncryptionCert;
        Field fieldIncludeCertInKeyInfo;
        this.assertionValidityBeforeMinutes = configuration.getIntFieldValue(FIELD_MIN_BEFORE);
        this.assertionValidityAfterMinutes = configuration.getIntFieldValue(FIELD_MIN_AFTER);
        if (StringUtils.isNotBlank((String)configuration.getFieldValue(FIELD_ISSUER))) {
            this.issuer = configuration.getFieldValue(FIELD_ISSUER);
        }
        if (StringUtils.isNotBlank((String)configuration.getFieldValue(FIELD_AUDIENCE))) {
            this.audience = configuration.getFieldValue(FIELD_AUDIENCE);
        }
        if (StringUtils.isNotBlank((String)configuration.getFieldValue(FIELD_CONFIRMATION_METHOD))) {
            this.confirmationMethod = configuration.getFieldValue(FIELD_CONFIRMATION_METHOD);
        }
        this.includeCertInKeyInfo = (fieldIncludeCertInKeyInfo = configuration.getField(FIELD_KEYINFO)) != null ? fieldIncludeCertInKeyInfo.getValueAsBoolean() : true;
        Field fieldIncludeRawKeyInKeyValue = configuration.getField(FIELD_KEYVALUE);
        if (fieldIncludeRawKeyInKeyValue != null) {
            this.includeRawKeyInKeyValue = fieldIncludeRawKeyInKeyValue.getValueAsBoolean();
        }
        KeyAccessor keyAccessor = new KeyAccessor();
        String signingCertFieldValue = configuration.getFieldValue(FIELD_SIGNING_CERT);
        this.signingCertificate = keyAccessor.getDsigKeypair(signingCertFieldValue);
        String selectedSigningAlgorithmName = configuration.getFieldValue(FIELD_SIGNING_ALGO);
        if (selectedSigningAlgorithmName != null) {
            this.signingAlgorithm = this.obtainSigningAlg(selectedSigningAlgorithmName, this.signingCertificate);
        }
        if ((fieldEncryptionCert = configuration.getField(FIELD_ENCRYPTION_CERT)) != null && StringUtils.isNotEmpty((String)fieldEncryptionCert.getValue())) {
            this.encryptionCertificate = keyAccessor.getEncryptionCertificate(fieldEncryptionCert.getValue());
        }
        Field expression = configuration.getField(FIELD_CUSTOMIZATION_EXPRESSION);
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn() && expression != null && StringUtils.isNotEmpty((String)expression.getValue())) {
            this.customisationExpression = expression.getValue();
        }
    }

    private String obtainSigningAlg(String selectedSigningAlgorithmName, X500PrivateCredential signingCertificate) {
        String signingAlgName = null;
        String signingAlgUri = null;
        SignatureAlgorithms signatureAlgsUtil = SignatureAlgorithms.getInstance();
        if (!StringUtils.isEmpty((String)selectedSigningAlgorithmName)) {
            if (selectedSigningAlgorithmName.equals(SHA1)) {
                if (signingCertificate != null && signingCertificate.getCertificate() != null) {
                    String signingCertAlgName = signingCertificate.getCertificate().getSigAlgName();
                    if (signingCertAlgName.trim().contains("DSA")) {
                        signingAlgName = "DSA_SHA1";
                    } else if (signingCertAlgName.contains("RSA")) {
                        signingAlgName = "RSA_SHA1";
                    }
                }
            } else {
                signingAlgName = selectedSigningAlgorithmName;
            }
            signingAlgUri = signatureAlgsUtil.algNameToUri(signingAlgName);
        }
        return signingAlgUri;
    }

    private List<AbstractSelectionFieldDescriptor.OptionValue> getSupportedSigningAlgs(SignatureAlgorithms signinAlgorithms) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        List<SignatureAlgorithm> supportedAlgs = signinAlgorithms.getSupportedSignatureAlgorithms();
        Collections.sort(supportedAlgs, SignatureAlgorithm.ALPHABETICAL);
        optionValues.add(SelectFieldDescriptor.SELECT_ONE);
        boolean sha1Added = false;
        for (SignatureAlgorithm supportedAlg : supportedAlgs) {
            String name = supportedAlg.getName();
            if (name.contains(SHA1)) {
                if (sha1Added) continue;
                AbstractSelectionFieldDescriptor.OptionValue optionalValue = new AbstractSelectionFieldDescriptor.OptionValue(SHA1, SHA1);
                optionValues.add(optionalValue);
                sha1Added = true;
                continue;
            }
            String nameWithNoUnderscore = supportedAlg.getName().replaceAll("_", " ");
            AbstractSelectionFieldDescriptor.OptionValue optionalValue = new AbstractSelectionFieldDescriptor.OptionValue(nameWithNoUnderscore, name);
            optionValues.add(optionalValue);
        }
        return optionValues;
    }

    protected void sign(XmlObject assertionDoc) throws TokenProcessingException {
        try {
            XmlSignatureUtil.signXml(assertionDoc, this.signingAlgorithm, this.signingCertificate.getPrivateKey(), this.signingCertificate.getCertificate(), this.includeCertInKeyInfo, true, this.includeRawKeyInKeyValue);
        }
        catch (SigningException e) {
            throw new TokenProcessingException("Problem encountered during SAML1.x assertion signing", (Throwable)e);
        }
    }

    protected <T extends XmlObject> T handleMessageCustomisation(Class<T> type, T assertionType, AttributeMap attributes, Map<String, Object> inParams) {
        Object customisedMessage = assertionType;
        if (StringUtils.isNotEmpty((String)this.getCustomisationExpression())) {
            MessageCustomization hook = new MessageCustomization();
            hook.setExpression(this.getCustomisationExpression());
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("XmlHelper", new XmlHelper());
            context.put("AssertionType", assertionType.copy());
            context.put("Attributes", attributes);
            if (inParams != null && !inParams.isEmpty()) {
                context.putAll(inParams);
            }
            try {
                Object result = ExpressionCalculator.calculate(hook.getParsedExpression(), context, context);
                customisedMessage = type.isInstance(result) ? (XmlObject)result : assertionType;
            }
            catch (OgnlException e) {
                throw new ProcessRuntimeException("Unable to process message customization expression.", e);
            }
        }
        return customisedMessage;
    }

    abstract String getGeneratorName();

    abstract String getTokenType();

    protected String getVersion() {
        return "UNDEFINED";
    }

    abstract List<String> getConfirmationMethods();

    String getCertificateFeatureName() {
        return this.getClass().getName();
    }

    class EntityIdValidator
    implements FieldValidator {
        EntityIdValidator() {
        }

        public void validate(Field field) throws ValidationException {
            if (!CommonValidator.isValidEntityId(field.getValue())) {
                throw new ValidationException(String.format("'%s' is not a valid anyURI", field.getLabel()));
            }
        }
    }
}

